/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Iterator;
import java.util.List;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPassageBook
extends AbstractBook {
    private String versification;
    private Versification versificationSystem;
    private PassageKeyFactory keyf = PassageKeyFactory.instance();
    private static final Logger log = LoggerFactory.getLogger(AbstractPassageBook.class);

    public AbstractPassageBook(BookMetaData bmd) {
        super(bmd);
        this.versification = (String)bmd.getProperty("Versification");
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, final boolean allowEmpty) throws BookException {
        final Filter filter = this.getFilter();
        Passage ref = KeyUtil.getPassage(key);
        final boolean showTitles = ref.hasRanges(RestrictionType.CHAPTER) || !allowEmpty;
        RawTextToXmlProcessor processor = new RawTextToXmlProcessor(){

            @Override
            public void preRange(VerseRange range, List<Content> partialDom) {
                if (showTitles) {
                    Element title = OSISUtil.factory().createGeneratedTitle();
                    title.addContent(range.getName());
                    partialDom.add((Content)title);
                }
            }

            @Override
            public void postVerse(Key verse, List<Content> partialDom, String rawText) {
                if (allowEmpty || rawText.length() > 0) {
                    List<Content> osisContent = filter.toOSIS(AbstractPassageBook.this, verse, rawText);
                    AbstractPassageBook.this.addOSIS(verse, partialDom, osisContent);
                }
            }

            @Override
            public void init(List<Content> partialDom) {
            }
        };
        return this.getOsis(ref, processor).iterator();
    }

    public void addOSIS(Key key, Element div, List<Content> osisContent) {
        assert (key != null);
        div.addContent(osisContent);
    }

    public void addOSIS(Key key, List<Content> content, List<Content> osisContent) {
        assert (key != null);
        content.addAll(osisContent);
    }

    protected abstract Filter getFilter();

    public void setDocument(Key key, BookData bdata) throws BookException {
        for (Content nextElem : OSISUtil.getFragment(bdata.getOsisFragment())) {
            if (nextElem instanceof Element) {
                Element div = (Element)nextElem;
                for (Content data : div.getContent()) {
                    if (data instanceof Element) {
                        Element overse = (Element)data;
                        String text = OSISUtil.getPlainText(overse);
                        this.setRawText(key, text);
                        continue;
                    }
                    log.error("Ignoring non OSIS/Verse content of DIV.");
                }
                continue;
            }
            log.error("Ignoring non OSIS/Verse content of DIV.");
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public final Key createEmptyKeyList() {
        return this.keyf.createEmptyKeyList(Versifications.instance().getVersification(this.versification));
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public final Key getKey(String text) throws NoSuchKeyException {
        return PassageKeyFactory.instance().getKey(Versifications.instance().getVersification(this.versification), text);
    }

    public Versification getVersification() {
        if (this.versificationSystem == null) {
            this.versificationSystem = Versifications.instance().getVersification((String)this.getBookMetaData().getProperty("Versification"));
        }
        return this.versificationSystem;
    }
}

