/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;
import org.crosswire.jsword.versification.Versification;

public class VerseCollector
extends Collector {
    private int docBase;
    private Versification v11n;
    private Searcher searcher;
    private Key results;

    public VerseCollector(Versification refSystem, Searcher searcher, Key results) {
        this.v11n = refSystem;
        this.searcher = searcher;
        this.results = results;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int docId) throws IOException {
        Document doc = this.searcher.doc(this.docBase + docId);
        try {
            Verse key = VerseFactory.fromString(this.v11n, doc.get("key"));
            this.results.addAll(key);
        }
        catch (NoSuchVerseException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }
}

