/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SimpleLuceneAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzerFactory {
    public static final String DEFAULT_ID = "Default";
    private static AnalyzerFactory myInstance = new AnalyzerFactory();
    private PropertyMap myProperties;
    private static final Logger log = LoggerFactory.getLogger(AnalyzerFactory.class);

    public AbstractBookAnalyzer createAnalyzer(Book book) {
        Language lang;
        AbstractBookAnalyzer newObject = null;
        Language language = lang = book == null ? null : book.getLanguage();
        if (lang != null) {
            String aClass = this.getAnalyzerValue(lang);
            log.debug("Creating analyzer:{} BookLang:{}", (Object)aClass, (Object)lang);
            if (aClass != null) {
                try {
                    Class<?> impl = ClassUtil.forName(aClass);
                    newObject = (AbstractBookAnalyzer)((Object)impl.newInstance());
                }
                catch (ClassNotFoundException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
            }
        }
        if (newObject == null) {
            newObject = new SimpleLuceneAnalyzer();
        }
        newObject.setBook(book);
        newObject.setDoStemming(this.getDefaultStemmingProperty());
        newObject.setDoStopWords(this.getDefaultStopWordProperty());
        return newObject;
    }

    public static AnalyzerFactory getInstance() {
        return myInstance;
    }

    private AnalyzerFactory() {
        this.loadProperties();
    }

    public String getAnalyzerValue(Language lang) {
        String key = lang.getCode() + ".Analyzer";
        return this.myProperties.get(key);
    }

    public boolean getDefaultStemmingProperty() {
        String key = "Default.Stemming";
        return Boolean.valueOf(this.myProperties.get(key));
    }

    public boolean getDefaultStopWordProperty() {
        String key = "Default.StopWord";
        return Boolean.valueOf(this.myProperties.get(key));
    }

    private void loadProperties() {
        try {
            this.myProperties = ResourceUtil.getProperties(this.getClass());
        }
        catch (IOException e) {
            log.error("AnalyzerFactory property load from file failed", (Throwable)e);
        }
    }
}

