/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;

final class ReadOnlyPassage
implements Passage {
    private Passage ref;
    private boolean ignore;
    private static final long serialVersionUID = 3257853173036102193L;

    protected ReadOnlyPassage(Passage ref, boolean ignore) {
        this.ref = ref;
        this.ignore = ignore;
    }

    @Override
    public Versification getVersification() {
        return this.ref.getVersification();
    }

    @Override
    public void addAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void removeAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void retainAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public boolean contains(Key key) {
        return this.ref.contains(key);
    }

    @Override
    public boolean canHaveChildren() {
        return this.ref.canHaveChildren();
    }

    @Override
    public int getChildCount() {
        return this.ref.getChildCount();
    }

    @Override
    public int getCardinality() {
        return this.ref.getCardinality();
    }

    @Override
    public Iterator<Key> iterator() {
        return this.ref.iterator();
    }

    @Override
    public Key get(int index) {
        return this.ref.get(index);
    }

    @Override
    public int indexOf(Key that) {
        return this.ref.indexOf(that);
    }

    @Override
    public Key getParent() {
        return this.ref.getParent();
    }

    @Override
    public String getName() {
        return this.ref.getName();
    }

    @Override
    public String getName(Key base) {
        return this.ref.getName(base);
    }

    @Override
    public String getRootName() {
        return this.ref.getRootName();
    }

    @Override
    public String getOsisRef() {
        return this.ref.getOsisRef();
    }

    @Override
    public String getOsisID() {
        return this.ref.getOsisID();
    }

    @Override
    public String getOverview() {
        return this.ref.getOverview();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.isEmpty();
    }

    @Override
    public int countVerses() {
        return this.ref.countVerses();
    }

    @Override
    public boolean hasRanges(RestrictionType restrict) {
        return this.ref.hasRanges(restrict);
    }

    @Override
    public int countRanges(RestrictionType restrict) {
        return this.ref.countRanges(restrict);
    }

    @Override
    public Passage trimVerses(int count) {
        return this.ref.trimVerses(count);
    }

    @Override
    public Passage trimRanges(int count, RestrictionType restrict) {
        return this.ref.trimRanges(count, restrict);
    }

    @Override
    public int booksInPassage() {
        return this.ref.booksInPassage();
    }

    @Override
    public Verse getVerseAt(int offset) throws ArrayIndexOutOfBoundsException {
        return this.ref.getVerseAt(offset);
    }

    @Override
    public VerseRange getRangeAt(int offset, RestrictionType restrict) throws ArrayIndexOutOfBoundsException {
        return this.ref.getRangeAt(offset, restrict);
    }

    @Override
    public Iterator<Key> rangeIterator(RestrictionType restrict) {
        return this.ref.rangeIterator(restrict);
    }

    @Override
    public void add(Key that) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void remove(Key that) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public boolean containsAll(Passage that) {
        return this.ref.containsAll(that);
    }

    @Override
    public void clear() {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void readDescription(Reader in) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(JSOtherMsg.lookupText("Cannot alter a read-only passage", new Object[0]));
    }

    @Override
    public void writeDescription(Writer out) throws IOException {
        this.ref.writeDescription(out);
    }

    @Override
    public void optimizeReads() {
        this.ref.optimizeReads();
    }

    @Override
    public void addPassageListener(PassageListener li) {
    }

    @Override
    public void removePassageListener(PassageListener li) {
    }

    @Override
    public boolean equals(Object obj) {
        return this.ref.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return this.ref.toString();
    }

    @Override
    public ReadOnlyPassage clone() {
        ReadOnlyPassage clone;
        block2: {
            clone = null;
            try {
                clone = (ReadOnlyPassage)super.clone();
                clone.ref = this.ref;
                clone.ignore = this.ignore;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return clone;
    }

    @Override
    public int compareTo(Key o) {
        return this.ref.compareTo(o);
    }
}

