/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.Locale;
import java.util.regex.Pattern;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.CaseType;
import org.crosswire.jsword.versification.BibleBook;

public final class BookName {
    private static Pattern normPattern = Pattern.compile("[. ]");
    private BibleBook book;
    private String longName;
    private String normalizedLongName;
    private String shortName;
    private String normalizedShortName;
    private String[] alternateNames;
    private Locale locale;
    private static CaseType bookCase = CaseType.SENTENCE;
    private static boolean fullBookName = true;

    public BookName(Locale locale, BibleBook book, String longName, String shortName, String alternateNames) {
        this.locale = locale;
        this.book = book;
        this.longName = longName;
        this.normalizedLongName = BookName.normalize(longName, locale);
        this.shortName = shortName;
        this.normalizedShortName = BookName.normalize(shortName, locale);
        if (alternateNames != null) {
            this.alternateNames = StringUtil.split(BookName.normalize(alternateNames, locale), ',');
        }
    }

    public BibleBook getBook() {
        return this.book;
    }

    public String getPreferredName() {
        if (BookName.isFullBookName()) {
            return this.getLongName();
        }
        return this.getShortName();
    }

    public String getLongName() {
        CaseType caseType = BookName.getDefaultCase();
        if (caseType == CaseType.LOWER) {
            return this.longName.toLowerCase(this.locale);
        }
        if (caseType == CaseType.UPPER) {
            return this.longName.toUpperCase(this.locale);
        }
        return this.longName;
    }

    public String getShortName() {
        CaseType caseType = BookName.getDefaultCase();
        if (caseType == CaseType.LOWER) {
            return this.shortName.toLowerCase(this.locale);
        }
        if (caseType == CaseType.UPPER) {
            return this.shortName.toUpperCase(this.locale);
        }
        return this.shortName;
    }

    public String getNormalizedLongName() {
        return this.normalizedLongName;
    }

    public String getNormalizedShortName() {
        return this.normalizedShortName;
    }

    public boolean match(String normalizedName) {
        for (int j = 0; j < this.alternateNames.length; ++j) {
            String targetBookName = this.alternateNames[j];
            if (!targetBookName.startsWith(normalizedName) && !normalizedName.startsWith(targetBookName)) continue;
            return true;
        }
        if (this.normalizedLongName.startsWith(normalizedName)) {
            return true;
        }
        return this.normalizedShortName.startsWith(normalizedName) || this.normalizedShortName.length() > 0 && normalizedName.startsWith(this.normalizedShortName);
    }

    public int hashCode() {
        return this.book.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BookName other = (BookName)obj;
        return this.book == other.book;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public static String normalize(String str, Locale locale) {
        return normPattern.matcher(str).replaceAll("").toLowerCase(locale);
    }

    public static void setCase(int bookCase) {
        BookName.bookCase = CaseType.fromInteger(bookCase);
    }

    public static int getCase() {
        return bookCase.toInteger();
    }

    public static void setCase(CaseType newBookCase) {
        bookCase = newBookCase;
    }

    public static boolean isFullBookName() {
        return fullBookName;
    }

    public static void setFullBookName(boolean fullName) {
        fullBookName = fullName;
    }

    public static CaseType getDefaultCase() {
        return bookCase;
    }
}

