/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.ProgressMode;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.jsword.JSMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
implements Progress {
    private static final int REPORTING_INTERVAL = 100;
    private static final int EXTRA_TIME = 200;
    private ProgressMode jobMode;
    private int totalUnits;
    private boolean cancelable;
    private boolean finished;
    private int workUnits;
    private int percent;
    private String jobName;
    private Thread workerThread;
    private String currentSectionName;
    private URI predictionMapURI;
    private Map<String, Integer> currentPredictionMap;
    private Map<String, Integer> nextPredictionMap;
    private long startTime;
    private Timer fakingTimer;
    private List<WorkListener> listeners;
    private static final Logger log = LoggerFactory.getLogger(Job.class);

    protected Job(String jobName, Thread worker) {
        this.jobName = jobName;
        this.workerThread = worker;
        this.listeners = new ArrayList<WorkListener>();
        this.cancelable = this.workerThread != null;
        this.jobMode = ProgressMode.PREDICTIVE;
    }

    @Override
    public void beginJob(String sectionName) {
        this.beginJob(sectionName, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginJob(String sectionName, int totalWork) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            this.finished = false;
            this.currentSectionName = sectionName;
            this.totalUnits = totalWork;
            this.jobMode = this.totalUnits == 100 ? ProgressMode.PERCENT : ProgressMode.UNITS;
        }
        JobManager.fireWorkProgressed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginJob(String sectionName, URI predictURI) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            this.currentSectionName = sectionName;
            this.predictionMapURI = predictURI;
            this.jobMode = ProgressMode.PREDICTIVE;
            this.startTime = System.currentTimeMillis();
            this.fakingTimer = new Timer();
            this.fakingTimer.schedule((TimerTask)new PredictTask(), 0L, 100L);
            this.totalUnits = this.loadPredictions();
            if (this.totalUnits == -1) {
                this.totalUnits = 200;
                this.jobMode = ProgressMode.UNKNOWN;
            }
            this.nextPredictionMap = new HashMap<String, Integer>();
        }
        JobManager.fireWorkProgressed(this);
    }

    @Override
    public synchronized String getJobName() {
        return this.jobName;
    }

    @Override
    public synchronized ProgressMode getProgressMode() {
        return this.jobMode;
    }

    @Override
    public synchronized int getTotalWork() {
        return this.totalUnits;
    }

    @Override
    public synchronized void setTotalWork(int totalWork) {
        this.totalUnits = totalWork;
    }

    @Override
    public synchronized int getWork() {
        return this.percent;
    }

    @Override
    public synchronized void setWork(int work) {
        this.setWorkDone(work);
    }

    @Override
    public synchronized int getWorkDone() {
        return this.workUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorkDone(int work) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            if (this.workUnits == work) {
                return;
            }
            this.workUnits = work;
            int oldPercent = this.percent;
            this.percent = 100 * this.workUnits / this.totalUnits;
            if (oldPercent == this.percent) {
                return;
            }
        }
        JobManager.fireWorkProgressed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementWorkDone(int step) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            this.workUnits += step;
            int oldPercent = this.percent;
            this.percent = (int)(100L * (long)this.workUnits / (long)this.totalUnits);
            if (oldPercent == this.percent) {
                return;
            }
        }
        JobManager.fireWorkProgressed(this);
    }

    @Override
    public synchronized String getSectionName() {
        return this.currentSectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSectionName(String sectionName) {
        if (this.finished) {
            return;
        }
        boolean doUpdate = false;
        Job job = this;
        synchronized (job) {
            if (this.jobMode == ProgressMode.PREDICTIVE || this.jobMode == ProgressMode.UNKNOWN) {
                doUpdate = this.updateProgress(System.currentTimeMillis());
                if (this.nextPredictionMap != null) {
                    this.nextPredictionMap.put(this.currentSectionName, this.workUnits);
                }
            }
            this.currentSectionName = sectionName;
        }
        if (doUpdate) {
            JobManager.fireWorkProgressed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        String sectionName = JSMsg.gettext("Done", new Object[0]);
        Job job = this;
        synchronized (job) {
            this.finished = true;
            this.currentSectionName = sectionName;
            if (this.fakingTimer != null) {
                this.fakingTimer.cancel();
                this.fakingTimer = null;
            }
            this.workUnits = this.totalUnits;
            this.percent = 100;
            if (this.nextPredictionMap != null) {
                this.nextPredictionMap.put(this.currentSectionName, (int)(System.currentTimeMillis() - this.startTime));
            }
        }
        JobManager.fireWorkProgressed(this);
        job = this;
        synchronized (job) {
            if (this.predictionMapURI != null) {
                this.savePredictions();
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.finished) {
            this.ignoreTimings();
            this.done();
            if (this.workerThread != null) {
                this.workerThread.interrupt();
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isCancelable() {
        return this.cancelable;
    }

    @Override
    public void setCancelable(boolean newInterruptable) {
        if (this.workerThread == null || this.finished) {
            return;
        }
        this.cancelable = newInterruptable;
        this.fireStateChanged();
    }

    public synchronized void addWorkListener(WorkListener li) {
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        temp.addAll(this.listeners);
        if (!temp.contains(li)) {
            temp.add(li);
            this.listeners = temp;
        }
    }

    public synchronized void removeWorkListener(WorkListener li) {
        if (this.listeners.contains(li)) {
            ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
            temp.addAll(this.listeners);
            temp.remove(li);
            this.listeners = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        WorkEvent ev = new WorkEvent(this);
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        Job job = this;
        synchronized (job) {
            if (this.listeners != null) {
                temp.addAll(this.listeners);
            }
        }
        int count = temp.size();
        for (int i = 0; i < count; ++i) {
            ((WorkListener)temp.get(i)).workStateChanged(ev);
        }
    }

    protected synchronized boolean updateProgress(long now) {
        int oldPercent = this.percent;
        this.workUnits = (int)(now - this.startTime);
        if (this.workUnits > this.totalUnits) {
            this.workUnits = this.totalUnits;
            this.percent = 100;
        } else {
            this.percent = 100 * this.workUnits / this.totalUnits;
        }
        return oldPercent != this.percent;
    }

    private int loadPredictions() {
        int maxAge = -1;
        try {
            this.currentPredictionMap = new HashMap<String, Integer>();
            PropertyMap temp = NetUtil.loadProperties(this.predictionMapURI);
            for (String title : temp.keySet()) {
                String timestr = temp.get(title);
                try {
                    Integer time = Integer.valueOf(timestr);
                    this.currentPredictionMap.put(title, time);
                    int age = time;
                    if (maxAge >= age) continue;
                    maxAge = age;
                }
                catch (NumberFormatException ex) {
                    log.error("Time format error", (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            log.debug("Failed to load prediction times - guessing");
        }
        return maxAge;
    }

    private void savePredictions() {
        PropertyMap predictions = new PropertyMap();
        for (String sectionName : this.nextPredictionMap.keySet()) {
            Integer age = this.nextPredictionMap.get(sectionName);
            predictions.put(sectionName, age.toString());
        }
        try {
            NetUtil.storeProperties(predictions, this.predictionMapURI, "Predicted Startup Times");
        }
        catch (IOException ex) {
            log.error("Failed to save prediction times", (Throwable)ex);
        }
    }

    private synchronized void ignoreTimings() {
        this.predictionMapURI = null;
    }

    final class PredictTask
    extends TimerTask {
        PredictTask() {
        }

        @Override
        public void run() {
            if (Job.this.updateProgress(System.currentTimeMillis())) {
                JobManager.fireWorkProgressed(Job.this);
            }
        }
    }
}

