/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobManager {
    private static List<WorkListener> listeners = new ArrayList<WorkListener>();
    private static Set<Progress> jobs = new HashSet<Progress>();
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);

    private JobManager() {
    }

    public static Progress createJob(String jobName) {
        return JobManager.createJob(jobName, null);
    }

    public static Progress createJob(String jobName, Thread workerThread) {
        Job job = new Job(jobName, workerThread);
        jobs.add(job);
        log.debug("job starting: {}", (Object)job.getJobName());
        return job;
    }

    public static synchronized void addWorkListener(WorkListener li) {
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        temp.addAll(listeners);
        if (!temp.contains(li)) {
            temp.add(li);
            listeners = temp;
        }
    }

    public static synchronized void removeWorkListener(WorkListener li) {
        if (listeners.contains(li)) {
            ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
            temp.addAll(listeners);
            temp.remove(li);
            listeners = temp;
        }
    }

    public static synchronized Set<Progress> getJobs() {
        HashSet<Progress> reply = new HashSet<Progress>();
        reply.addAll(jobs);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireWorkProgressed(Progress job) {
        WorkEvent ev = new WorkEvent(job);
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            temp.addAll(listeners);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (listeners != null) {
                for (WorkListener worker : temp) {
                    worker.workProgressed(ev);
                }
            }
            clazz = JobManager.class;
            synchronized (JobManager.class) {
                if (job.isFinished()) {
                    log.debug("job finished: {}", (Object)job.getJobName());
                    jobs.remove(job);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

