/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyMap
extends LinkedHashMap<String, String> {
    private PropertyMap defaults;
    private static final long serialVersionUID = 2821277155924802795L;

    public PropertyMap() {
        this((PropertyMap)null);
    }

    public PropertyMap(PropertyMap defaults) {
        this.defaults = defaults;
    }

    public String get(String key) {
        String value = (String)super.get(key);
        return value == null && this.defaults != null ? this.defaults.get(key) : value;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Deprecated
    public String setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Deprecated
    public String getProperty(String key) {
        return this.get(key);
    }

    @Deprecated
    public String getProperty(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    public void load(InputStream inStream) throws IOException {
        Properties prop = new Properties();
        prop.load(inStream);
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = prop.get(k);
            if (!(k instanceof String) || !(v instanceof String)) continue;
            this.put((String)k, (String)v);
        }
    }

    public void store(OutputStream out, String comments) throws IOException {
        Properties temp = new Properties();
        temp.putAll((Map<?, ?>)this);
        temp.store(out, comments);
    }
}

