/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.Writer;
import org.crosswire.common.xml.FormatType;
import org.crosswire.common.xml.PrettySerializingContentHandler;
import org.crosswire.common.xml.XMLUtil;

public class HTMLSerializingContentHandler
extends PrettySerializingContentHandler {
    public HTMLSerializingContentHandler() {
    }

    public HTMLSerializingContentHandler(FormatType theFormat) {
        super(theFormat);
    }

    public HTMLSerializingContentHandler(FormatType theFormat, Writer theWriter) {
        super(theFormat, theWriter);
    }

    @Override
    protected String decorateTagName(String tagName) {
        StringBuilder buf = new StringBuilder(50);
        buf.append("<font class='tag'>");
        buf.append(super.decorateTagName(tagName));
        buf.append("</font>");
        return buf.toString();
    }

    @Override
    protected String decorateAttributeName(String attrName) {
        StringBuilder buf = new StringBuilder(50);
        buf.append("<font class='attr'>");
        buf.append(super.decorateAttributeName(attrName));
        buf.append("</font>");
        return buf.toString();
    }

    @Override
    protected String decorateAttributeValue(String attrValue) {
        StringBuilder buf = new StringBuilder(50);
        buf.append("<font class='value'>");
        buf.append(super.decorateAttributeValue(attrValue));
        buf.append("</font>");
        return buf.toString();
    }

    @Override
    protected String decorateCharacters(String characters) {
        StringBuilder buf = new StringBuilder(50);
        buf.append("<font class='text'>");
        buf.append(XMLUtil.escape(super.decorateCharacters(characters)).replaceAll("\n", "<br>"));
        buf.append("</font>");
        return buf.toString();
    }

    @Override
    protected String decorateIndent(int indentLevel) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("<font class='indent'>");
        buf.append(super.decorateIndent(indentLevel).replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"));
        buf.append("</font>");
        return buf.toString();
    }

    @Override
    public void startDocument() {
        this.write("<html><head><style type='text/css'>\nFONT.tag    { font-family:courier new, monospaced; color:#666699; font-weight:bold; }\nFONT.attr   { font-family:courier new, monospaced; color:#669966; font-weight:bold; }\nFONT.value  { font-family:courier new, monospaced; color:#669966; font-style:italic; }\nFONT.indent { }\nFONT.text   { font-family:courier new, monospaced; background:#FFFF99; }\n</style></head><body>\n");
    }

    @Override
    public void endDocument() {
        this.write("</body></head>");
    }

    @Override
    protected String getEmptyTagEnd() {
        return XMLUtil.escape(super.getEmptyTagEnd());
    }

    @Override
    protected String getEndTagStart() {
        return XMLUtil.escape(super.getEndTagStart());
    }

    @Override
    protected String getPIEnd() {
        return XMLUtil.escape(super.getPIEnd());
    }

    @Override
    protected String getPIStart() {
        return XMLUtil.escape(super.getPIStart());
    }

    @Override
    protected String getTagEnd() {
        return XMLUtil.escape(super.getTagEnd());
    }

    @Override
    protected String getTagStart() {
        return XMLUtil.escape(super.getTagStart());
    }

    @Override
    protected String getNewline() {
        return "<br>";
    }
}

