/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.search.DefaultSearchModifier;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.SAXException;

public class APIExamples {
    private static final String BIBLE_NAME = "KJV";

    public Book getBook(String bookInitials) {
        return Books.installed().getBook(bookInitials);
    }

    public String getPlainText(String bookInitials, String reference) throws BookException, NoSuchKeyException {
        Book book = this.getBook(bookInitials);
        if (book == null) {
            return "";
        }
        Key key = book.getKey(reference);
        BookData data = new BookData(book, key);
        return OSISUtil.getCanonicalText(data.getOsisFragment());
    }

    public SAXEventProvider getOSIS(String bookInitials, String reference, int maxKeyCount) throws BookException, NoSuchKeyException {
        if (bookInitials == null || reference == null) {
            return null;
        }
        Book book = this.getBook(bookInitials);
        Key key = null;
        if (BookCategory.BIBLE.equals((Object)book.getBookCategory())) {
            key = book.getKey(reference);
            ((Passage)key).trimVerses(maxKeyCount);
        } else {
            key = book.createEmptyKeyList();
            int count = 0;
            for (Key aKey : book.getKey(reference)) {
                if (++count >= maxKeyCount) break;
                key.addAll(aKey);
            }
        }
        BookData data = new BookData(book, key);
        return data.getSAXEventProvider();
    }

    public String readStyledText(String bookInitials, String reference, int maxKeyCount) throws NoSuchKeyException, BookException, TransformerException, SAXException {
        Book book = this.getBook(bookInitials);
        SAXEventProvider osissep = this.getOSIS(bookInitials, reference, maxKeyCount);
        if (osissep == null) {
            return "";
        }
        Converter styler = ConverterFactory.getConverter();
        TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)styler.convert(osissep);
        BookMetaData bmd = book.getBookMetaData();
        boolean direction = bmd.isLeftToRight();
        htmlsep.setParameter("direction", direction ? "ltr" : "rtl");
        return XMLUtil.writeToString(htmlsep);
    }

    public void readDictionary() throws BookException {
        List<Book> dicts = Books.installed().getBooks(BookFilters.getDictionaries());
        Book dict = dicts.get(0);
        Key keys = dict.getGlobalKeyList();
        Key first = (Key)keys.iterator().next();
        System.out.println("The first Key in the default dictionary is " + first);
        BookData data = new BookData(dict, first);
        System.out.println("And the text against that key is " + OSISUtil.getPlainText(data.getOsisFragment()));
    }

    public void search() throws BookException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.find("+moses +aaron");
        System.out.println("The following verses contain both moses and aaron: " + key.getName());
        if (key instanceof Passage) {
            Passage remaining = ((Passage)key).trimVerses(5);
            System.out.println("The first 5 verses containing both moses and aaron: " + key.getName());
            if (remaining != null) {
                System.out.println("The rest of the verses are: " + remaining.getName());
            } else {
                System.out.println("There are only 5 verses containing both moses and aaron");
            }
        }
    }

    void rankedSearch() throws BookException {
        int total;
        Book bible = Books.installed().getBook(BIBLE_NAME);
        boolean rank = true;
        int max = 20;
        DefaultSearchModifier modifier = new DefaultSearchModifier();
        modifier.setRanked(rank);
        modifier.setMaxResults(max);
        Key results = bible.find(new DefaultSearchRequest("for god so loved the world", modifier));
        int partial = total = results.getCardinality();
        if (results instanceof PassageTally || rank) {
            PassageTally tally = (PassageTally)results;
            tally.setOrdering(PassageTally.Order.TALLY);
            int rankCount = max;
            if (rankCount > 0 && rankCount < total) {
                tally.trimRanges(rankCount, RestrictionType.NONE);
                partial = rankCount;
            }
        }
        System.out.println("Showing the first " + partial + " of " + total + " verses.");
        System.out.println(results);
    }

    void searchAndShow() throws BookException, SAXException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.find("melchesidec~");
        String path = "xsl/cswing/simple.xsl";
        URL xslurl = ResourceUtil.getResource(path);
        Iterator<Key> rangeIter = ((Passage)key).rangeIterator(RestrictionType.CHAPTER);
        while (rangeIter.hasNext()) {
            Key range = rangeIter.next();
            BookData data = new BookData(bible, range);
            SAXEventProvider osissep = data.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = new TransformingSAXEventProvider(NetUtil.toURI(xslurl), osissep);
            String text = XMLUtil.writeToString(htmlsep);
            System.out.println("The html text of " + range.getName() + " is " + text);
        }
    }

    public void pickBible() {
        Book book = Books.installed().getBook(BIBLE_NAME);
        System.out.println(book.getLanguage());
        List<Book> books = Books.installed().getBooks();
        book = books.get(0);
        books = Books.installed().getBooks(BookFilters.getOnlyBibles());
        book = books.get(0);
        List<Book> test = Books.installed().getBooks(new MyBookFilter("ESV"));
        book = test.get(0);
        if (book != null) {
            System.out.println(book.getInitials());
        }
        Books.installed().addBooksListener(new MyBooksListener());
    }

    public void installBook() {
        Installer installer = null;
        InstallManager imanager = new InstallManager();
        Map<String, Installer> installers = imanager.getInstallers();
        String name = null;
        for (Map.Entry<String, Installer> mapEntry : installers.entrySet()) {
            name = mapEntry.getKey();
            installer = mapEntry.getValue();
            System.out.println(name + ": " + installer.getInstallerDefinition());
        }
        name = "CrossWire";
        installer = imanager.getInstaller(name);
        try {
            installer.reloadBookList();
        }
        catch (InstallException e) {
            e.printStackTrace();
        }
        List<Book> availableBooks = installer.getBooks();
        Book book = availableBooks.get(0);
        if (book != null) {
            System.out.println("Book " + book.getInitials() + " is available");
        }
        if ((book = (availableBooks = installer.getBooks(new MyBookFilter("ESV"))).get(0)) != null) {
            System.out.println("Book " + book.getInitials() + " is available");
            try {
                if (Books.installed().getBook("ESV") != null) {
                    Books.installed().removeBook(book);
                    book.getDriver().delete(book);
                }
            }
            catch (BookException e1) {
                e1.printStackTrace();
            }
            try {
                installer.install(book);
            }
            catch (InstallException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws BookException, NoSuchKeyException, TransformerException, SAXException {
        APIExamples examples = new APIExamples();
        examples.installBook();
        System.out.println("The plain text of Gen 1:1 is " + examples.getPlainText(BIBLE_NAME, "Gen 1:1"));
        System.out.println("The html text of Gen 1:1 is " + examples.readStyledText(BIBLE_NAME, "Gen 1:1", 100));
        examples.readDictionary();
        examples.search();
        examples.rankedSearch();
        examples.searchAndShow();
    }

    static class MyBooksListener
    implements BooksListener {
        MyBooksListener() {
        }

        @Override
        public void bookAdded(BooksEvent ev) {
        }

        @Override
        public void bookRemoved(BooksEvent ev) {
        }
    }

    static class MyBookFilter
    implements BookFilter {
        private String name;

        public MyBookFilter(String bookName) {
            this.name = bookName;
        }

        @Override
        public boolean test(Book bk) {
            return bk.getInitials().equals(this.name);
        }
    }
}

