/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.versification.BibleBook;

public enum DivisionName {
    BIBLE{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.REV.ordinal();
        }

        @Override
        public int getSize() {
            return 66;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("The Whole Bible", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Gen-Rev";
        }
    }
    ,
    OLD_TESTAMENT{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        @Override
        public int getSize() {
            return 39;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Old Testament", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Gen-Mal";
        }
    }
    ,
    PENTATEUCH{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.DEUT.ordinal();
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Pentateuch", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Gen-Deu";
        }
    }
    ,
    HISTORY{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JOSH.ordinal() && bookNum <= BibleBook.ESTH.ordinal();
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("History", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Jos-Est";
        }
    }
    ,
    POETRY{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JOB.ordinal() && bookNum <= BibleBook.SONG.ordinal();
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Poetry", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Job-Song";
        }
    }
    ,
    PROPHECY{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum == BibleBook.REV.ordinal() || bookNum >= BibleBook.ISA.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        @Override
        public int getSize() {
            return 18;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("All Prophecy", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Deu 28,Isa-Mal,Rev";
        }
    }
    ,
    MAJOR_PROPHETS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ISA.ordinal() && bookNum <= BibleBook.DAN.ordinal();
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Major Prophets", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Isa-Dan";
        }
    }
    ,
    MINOR_PROPHETS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.HOS.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Minor Prophets", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Hos-Mal";
        }
    }
    ,
    NEW_TESTAMENT{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.REV.ordinal();
        }

        @Override
        public int getSize() {
            return 27;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("New Testament", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Mat-Rev";
        }
    }
    ,
    GOSPELS_AND_ACTS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.MATT.ordinal() && bookNum <= BibleBook.ACTS.ordinal();
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Gospels and Acts", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Mat-Acts";
        }
    }
    ,
    LETTERS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ROM.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        @Override
        public int getSize() {
            return 21;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Letters", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Rom-Jud";
        }
    }
    ,
    PAULINE_LETTERS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ROM.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        @Override
        public int getSize() {
            return 14;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Letters to People", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Rom-Heb";
        }
    }
    ,
    GENERAL_LETTERS{

        @Override
        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JAS.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        @Override
        public int getSize() {
            return 7;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Letters from People", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Jas-Jud";
        }
    }
    ,
    REVELATION{

        @Override
        public boolean contains(BibleBook book) {
            return book == BibleBook.REV;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getName() {
            return JSMsg.gettext("Revelation", new Object[0]);
        }

        @Override
        public String getRange() {
            return "Rev";
        }
    };


    public abstract boolean contains(BibleBook var1);

    public abstract int getSize();

    public abstract String getName();

    public abstract String getRange();

    public String toString() {
        return this.getName();
    }

    public static DivisionName getSection(BibleBook book) {
        if (LETTERS.contains(book)) {
            return LETTERS;
        }
        if (HISTORY.contains(book)) {
            return HISTORY;
        }
        if (MINOR_PROPHETS.contains(book)) {
            return MINOR_PROPHETS;
        }
        if (GOSPELS_AND_ACTS.contains(book)) {
            return GOSPELS_AND_ACTS;
        }
        if (PENTATEUCH.contains(book)) {
            return PENTATEUCH;
        }
        if (POETRY.contains(book)) {
            return POETRY;
        }
        if (MAJOR_PROPHETS.contains(book)) {
            return MAJOR_PROPHETS;
        }
        return REVELATION;
    }
}

