/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.TitledBorder;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.book.install.BookFont;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.LazyHTMLEditorKit;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.SAXException;

public class ActiveURITip
extends MouseAdapter
implements URIEventListener {
    private JTextPane owner;
    private LazyHTMLEditorKit lazykit;
    private JTextPane txtView;
    private JScrollPane scrView;
    private TitledBorder title;
    private Popup popup;
    private int lastx;
    private int lasty;
    private int lastb;
    private Converter converter = ConverterFactory.getConverter();

    public ActiveURITip(JTextPane own, Dimension dim) {
        this.owner = own;
        this.lazykit = (LazyHTMLEditorKit)own.getEditorKit();
        this.txtView = new AntiAliasedTextPane();
        this.txtView.setEditable(false);
        this.txtView.setEditorKit(new LazyHTMLEditorKit());
        this.title = new TitledBorder((String)null);
        this.scrView = new JScrollPane(this.txtView);
        this.scrView.setBackground(Color.yellow);
        this.scrView.setBorder(this.title);
        this.scrView.getViewport().setPreferredSize(dim);
        own.addMouseListener(this);
    }

    public void updateText(URIEvent event) {
        if (event == null) {
            return;
        }
        String txt = null;
        String protocol = event.getScheme();
        Book book = null;
        if (protocol.equals("gdef")) {
            book = Defaults.getGreekDefinitions();
            this.title.setTitle("Greek Definition");
        } else if (protocol.equals("hdef")) {
            book = Defaults.getHebrewDefinitions();
            this.title.setTitle("Hebrew Definition");
        } else if (protocol.equals("gmorph")) {
            book = Defaults.getGreekParse();
            this.title.setTitle("Greek Morphology");
        } else if (protocol.equals("hmorph")) {
            book = Defaults.getHebrewParse();
            this.title.setTitle("Hebrew Morphology");
        }
        if (book == null || Books.installed().getBook(book.getName()) == null) {
            this.txtView.setText("Book Unavailable!");
            this.title.setTitle("Exception");
            return;
        }
        BookData bdata = null;
        try {
            bdata = new BookData(book, book.getKey(event.getURI()));
        }
        catch (NoSuchKeyException ex) {
            this.txtView.setText(ex.getDetailedMessage());
            this.title.setTitle("Exception");
            return;
        }
        assert (book == bdata.getFirstBook());
        BookMetaData bmd = book.getBookMetaData();
        if (bmd == null) {
            this.txtView.setText("Book Meta Data Unavailable!");
            this.title.setTitle("Exception");
            return;
        }
        boolean direction = bmd.isLeftToRight();
        String fontSpec = GuiConvert.font2String(BookFont.instance().getFont(book));
        try {
            SAXEventProvider osissep = bdata.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)this.converter.convert(osissep);
            XSLTProperty.DIRECTION.setState(direction ? "ltr" : "rtl");
            URI loc = bmd.getLocation();
            XSLTProperty.BASE_URL.setState(loc == null ? "" : loc.getPath());
            if (bmd.getBookCategory() == BookCategory.BIBLE) {
                XSLTProperty.setProperties(htmlsep);
            } else {
                XSLTProperty.CSS.setProperty(htmlsep);
                XSLTProperty.BASE_URL.setProperty(htmlsep);
                XSLTProperty.DIRECTION.setProperty(htmlsep);
            }
            htmlsep.setParameter(XSLTProperty.FONT.getName(), (Object)fontSpec);
            txt = XMLUtil.writeToString((SAXEventProvider)htmlsep);
        }
        catch (SAXException e) {
            Reporter.informUser((Object)this, (Throwable)e);
            e.printStackTrace();
            this.txtView.setText(e.getMessage());
            this.title.setTitle("Exception");
        }
        catch (TransformerException e) {
            Reporter.informUser((Object)this, (Throwable)e);
            e.printStackTrace();
            this.txtView.setText(e.getMessage());
            this.title.setTitle("Exception");
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            e.printStackTrace();
            this.txtView.setText(e.getMessage());
            this.title.setTitle("Exception");
        }
        GuiUtil.applyOrientation((Component)this.txtView, direction);
        this.txtView.setLocale(new Locale(bmd.getLanguage().getCode()));
        this.txtView.setText(txt);
        this.txtView.setCaretPosition(0);
    }

    void showTip() {
        Point p = this.owner.getLocationOnScreen();
        Dimension d = this.scrView.getPreferredSize();
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        int x = p.x + this.lastx;
        int y = p.y + this.lasty;
        int horizDist = 30;
        int vertiDist = 10;
        x = x + x > s.width ? (x -= horizDist + d.width) : (x += horizDist);
        y = y + y > s.height ? (y -= vertiDist + d.height) : (y += vertiDist);
        this.popup = PopupFactory.getSharedInstance().getPopup(this.owner, this.scrView, x, y);
        this.popup.show();
    }

    void hideTip() {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = null;
    }

    boolean interested(URIEvent ev) {
        String protocol = ev.getScheme();
        if (protocol.equals("gdef")) {
            return true;
        }
        if (protocol.equals("hdef")) {
            return true;
        }
        if (protocol.equals("gmorph")) {
            return true;
        }
        return protocol.equals("hmorph");
    }

    @Override
    public void activateURI(URIEvent ev) {
    }

    @Override
    public void enterURI(URIEvent ev) {
        System.out.println(ev);
        if (this.interested(ev) && this.lastb == 3) {
            this.updateText(ev);
            this.showTip();
        }
    }

    @Override
    public void leaveURI(URIEvent ev) {
        this.hideTip();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastx = e.getX();
        this.lasty = e.getY();
        this.lastb = e.getButton();
        this.lazykit.getLinkCtrl().mouseMoved(e);
    }
}

