/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.crosswire.bibledesktop.passage.KeyTreeNode;
import org.crosswire.jsword.passage.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Logger log = LoggerFactory.getLogger(KeyTreeCellRenderer.class);
    private static final long serialVersionUID = 3545232531516765241L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isselected, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, isselected, expanded, leaf, row, focus);
        if (value instanceof KeyTreeNode) {
            KeyTreeNode keytn = (KeyTreeNode)value;
            Key key = keytn.getKey();
            if (key != null) {
                this.setText(key.getName());
            }
        } else {
            log.warn("value is not a key: {}", (Object)value.getClass().getName());
        }
        return this;
    }
}

