/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import org.crosswire.common.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class SerializingContentHandler
implements ContentHandler {
    private boolean newlines;
    private StringBuilder buffer = new StringBuilder();

    public SerializingContentHandler() {
        this.newlines = false;
    }

    public SerializingContentHandler(boolean newlines) {
        this.newlines = newlines;
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
        if (this.newlines) {
            this.buffer.append('\n');
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attrs) {
        this.buffer.append('<');
        if (qname != null) {
            this.buffer.append(qname);
        } else {
            this.buffer.append(localname);
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.buffer.append(' ');
            this.buffer.append(XMLUtil.getAttributeName(attrs, i));
            this.buffer.append("=\"");
            this.buffer.append(attrs.getValue(i));
            this.buffer.append('\"');
        }
        this.buffer.append('>');
        if (this.newlines) {
            this.buffer.append('\n');
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) {
        this.buffer.append("</");
        if (qname != null) {
            this.buffer.append(qname);
        } else {
            this.buffer.append(localname);
        }
        this.buffer.append('>');
        if (this.newlines) {
            this.buffer.append('\n');
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        String s = new String(chars, start, length);
        this.buffer.append(s);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) {
        String s = new String(chars, start, length);
        this.buffer.append(s);
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.buffer.append("<!");
        this.buffer.append(target);
        this.buffer.append(' ');
        this.buffer.append(data);
        this.buffer.append("!>");
        if (this.newlines) {
            this.buffer.append('\n');
        }
    }

    @Override
    public void skippedEntity(String name) {
    }
}

