/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.state.GenBookBackendState;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.book.sword.state.RawBackendState;
import org.crosswire.jsword.book.sword.state.RawFileBackendState;
import org.crosswire.jsword.book.sword.state.RawLDBackendState;
import org.crosswire.jsword.book.sword.state.ZLDBackendState;
import org.crosswire.jsword.book.sword.state.ZVerseBackendState;

public final class OpenFileStateManager {
    private static volatile Map<SwordBookMetaData, Queue<OpenFileState>> metaToStates = new HashMap<SwordBookMetaData, Queue<OpenFileState>>();
    private static volatile boolean shuttingDown;

    private OpenFileStateManager() {
    }

    public static RawBackendState getRawBackendState(SwordBookMetaData metadata) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        RawBackendState state = (RawBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new RawBackendState(metadata);
        }
        return state;
    }

    public static RawFileBackendState getRawFileBackendState(SwordBookMetaData metadata) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        RawFileBackendState state = (RawFileBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new RawFileBackendState(metadata);
        }
        return state;
    }

    public static GenBookBackendState getGenBookBackendState(SwordBookMetaData metadata) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        GenBookBackendState state = (GenBookBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new GenBookBackendState(metadata);
        }
        return state;
    }

    public static RawLDBackendState getRawLDBackendState(SwordBookMetaData metadata) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        RawLDBackendState state = (RawLDBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new RawLDBackendState(metadata);
        }
        return state;
    }

    public static ZLDBackendState getZLDBackendState(SwordBookMetaData metadata) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        ZLDBackendState state = (ZLDBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new ZLDBackendState(metadata);
        }
        return state;
    }

    public static ZVerseBackendState getZVerseBackendState(SwordBookMetaData metadata, BlockType blockType) throws BookException {
        OpenFileStateManager.ensureNotShuttingDown();
        ZVerseBackendState state = (ZVerseBackendState)OpenFileStateManager.getInstance(metadata);
        if (state == null) {
            state = new ZVerseBackendState(metadata, blockType);
        }
        return state;
    }

    private static <T extends OpenFileState> T getInstance(SwordBookMetaData metadata) {
        Queue<OpenFileState> availableStates = OpenFileStateManager.getQueueForMeta(metadata);
        return (T)availableStates.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Queue<OpenFileState> getQueueForMeta(SwordBookMetaData metadata) {
        Queue<OpenFileState> availableStates = metaToStates.get(metadata);
        if (availableStates != null) return availableStates;
        Class<OpenFileState> clazz = OpenFileState.class;
        synchronized (OpenFileState.class) {
            availableStates = new ConcurrentLinkedQueue<OpenFileState>();
            metaToStates.put(metadata, availableStates);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return availableStates;
        }
    }

    public static void release(OpenFileState fileState) {
        if (fileState == null) {
            return;
        }
        Queue<OpenFileState> queueForMeta = OpenFileStateManager.getQueueForMeta(fileState.getBookMetaData());
        boolean offered = queueForMeta.offer(fileState);
        if (!offered) {
            fileState.releaseResources();
        }
    }

    public static void shutDown() {
        shuttingDown = true;
        for (Queue<OpenFileState> e : metaToStates.values()) {
            OpenFileState state = null;
            while ((state = e.poll()) != null) {
                state.releaseResources();
            }
        }
    }

    private static void ensureNotShuttingDown() throws BookException {
        if (shuttingDown) {
            throw new BookException("Unable to read book, application is shutting down.");
        }
    }
}

