/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Map;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Convert {
    private static final Logger log = LoggerFactory.getLogger(Convert.class);

    private Convert() {
    }

    public static boolean string2Boolean(String data) {
        return Boolean.valueOf(data) != false || "yes".equalsIgnoreCase(data) || "ok".equalsIgnoreCase(data) || "okay".equalsIgnoreCase(data) || "on".equalsIgnoreCase(data) || "1".equals(data);
    }

    public static String boolean2String(boolean data) {
        return Boolean.toString(data);
    }

    public static int string2Int(String data) {
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static String int2String(int data) {
        return Integer.toString(data);
    }

    public static Object string2Object(String data) throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        return ClassUtil.forName(data).newInstance();
    }

    public static String object2String(Object data) {
        return data.getClass().getName();
    }

    public static Class<?> string2Class(String data) throws ClassNotFoundException {
        return ClassUtil.forName(data);
    }

    public static String class2String(Class<?> data) {
        return data.getName();
    }

    public static PropertyMap string2Hashtable(String data, Class<?> superclass) {
        PropertyMap commands = new PropertyMap();
        String[] data_arr = StringUtil.split(data, " ");
        String entry = "";
        for (int i = 0; i < data_arr.length; ++i) {
            try {
                entry = data_arr[i];
                int equ_pos = entry.indexOf(61);
                String key = entry.substring(0, equ_pos);
                String value = entry.substring(equ_pos + 1);
                Class<?> clazz = ClassUtil.forName(value);
                if (clazz.isAssignableFrom(superclass)) {
                    assert (false);
                    continue;
                }
                commands.put(key, value);
                continue;
            }
            catch (ClassNotFoundException ex) {
                log.warn("Invalid config file entry: {} System message: {}", (Object)entry, (Object)ex.getMessage());
                Reporter.informUser(Convert.class, ex);
            }
        }
        return commands;
    }

    public static PropertyMap string2Map(String data) {
        return Convert.string2Hashtable(data, Object.class);
    }

    public static String map2String(Map<? extends Object, ? extends Object> commands) {
        StringBuilder retcode = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : commands.entrySet()) {
            retcode.append(entry.getKey());
            retcode.append('=');
            retcode.append(entry.getValue());
            retcode.append(' ');
        }
        return retcode.toString().trim();
    }

    public static String[] string2StringArray(String value, String separator) {
        return StringUtil.split(value, separator);
    }

    public static String stringArray2String(String[] value, String separator) {
        return StringUtil.join(value, separator);
    }
}

