/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.AbstractBookList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookDriver;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwordInstaller
extends AbstractBookList
implements Installer,
Comparable<AbstractSwordInstaller> {
    protected Map<String, Book> entries = new HashMap<String, Book>();
    protected String host;
    protected String proxyHost;
    protected Integer proxyPort;
    protected String packageDirectory = "";
    protected String catalogDirectory = "";
    protected String indexDirectory = "";
    protected boolean loaded;
    protected static final String FILE_LIST_GZ = "mods.d.tar.gz";
    protected static final String ZIP_SUFFIX = ".zip";
    protected static final String SEARCH_DIR = "search/jsword/L1";
    protected static final String DOWNLOAD_PREFIX = "download-";
    protected static final Logger log = LoggerFactory.getLogger(AbstractSwordInstaller.class);

    protected abstract void download(Progress var1, String var2, String var3, URI var4) throws InstallException;

    @Override
    public String getInstallerDefinition() {
        StringBuilder buf = new StringBuilder(this.host);
        buf.append(',');
        buf.append(this.packageDirectory);
        buf.append(',');
        buf.append(this.catalogDirectory);
        buf.append(',');
        buf.append(this.indexDirectory);
        buf.append(',');
        if (this.proxyHost != null) {
            buf.append(this.proxyHost);
        }
        buf.append(',');
        if (this.proxyPort != null) {
            buf.append(this.proxyPort);
        }
        return buf.toString();
    }

    @Override
    public boolean isNewer(Book book) {
        SwordBookMetaData sbmd = (SwordBookMetaData)book.getBookMetaData();
        File conf = sbmd.getConfigFile();
        if (conf == null || !conf.exists()) {
            return false;
        }
        URI configURI = NetUtil.getURI(conf);
        URI remote = this.toRemoteURI(book);
        return NetUtil.isNewer(remote, configURI, this.proxyHost, this.proxyPort);
    }

    @Override
    public List<Book> getBooks() {
        try {
            if (!this.loaded) {
                this.loadCachedIndex();
            }
            return new ArrayList<Book>(this.entries.values());
        }
        catch (InstallException ex) {
            log.error("Failed to reload cached index file", (Throwable)ex);
            return new ArrayList<Book>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book getBook(String name) {
        List<Book> books = null;
        AbstractSwordInstaller abstractSwordInstaller = this;
        synchronized (abstractSwordInstaller) {
            books = this.getBooks();
        }
        for (Book book : books) {
            if (!name.equals(book.getName())) continue;
            return book;
        }
        for (Book book : books) {
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        for (Book book : books) {
            BookMetaData bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        for (Book book : books) {
            if (!name.equalsIgnoreCase(book.getInitials())) continue;
            return book;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Book> getBooks(BookFilter filter) {
        List<Book> books = null;
        AbstractSwordInstaller abstractSwordInstaller = this;
        synchronized (abstractSwordInstaller) {
            books = this.getBooks();
        }
        List<Book> temp = CollectionUtil.createList(new BookFilterIterator(books, filter));
        return new BookSet((Collection<Book>)temp);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void install(Book book) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void reloadBookList() throws InstallException {
        String jobName = JSMsg.gettext("Downloading files", new Object[0]);
        Progress job = JobManager.createJob(jobName, Thread.currentThread());
        job.beginJob(jobName);
        try {
            URI scratchfile = this.getCachedIndexFile();
            this.download(job, this.catalogDirectory, FILE_LIST_GZ, scratchfile);
            this.loaded = false;
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    @Override
    public void downloadSearchIndex(Book book, URI localDest) throws InstallException {
        String jobName = JSMsg.gettext("Downloading files", new Object[0]);
        Progress job = JobManager.createJob(jobName, Thread.currentThread());
        job.beginJob(jobName);
        try {
            this.download(job, this.packageDirectory + '/' + SEARCH_DIR, book.getInitials() + ZIP_SUFFIX, localDest);
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    private void loadCachedIndex() throws InstallException {
        BookDriver fake = SwordBookDriver.instance();
        this.entries.clear();
        URI cache = this.getCachedIndexFile();
        if (!NetUtil.isFile(cache)) {
            this.reloadBookList();
        }
        InputStream in = null;
        GZIPInputStream gin = null;
        TarInputStream tin = null;
        try {
            TarEntry entry;
            ConfigEntry.resetStatistics();
            in = NetUtil.getInputStream(cache);
            gin = new GZIPInputStream(in);
            tin = new TarInputStream((InputStream)gin);
            while ((entry = tin.getNextEntry()) != null) {
                String internal = entry.getName();
                if (entry.isDirectory()) continue;
                try {
                    int size = (int)entry.getSize();
                    if (size == 0) {
                        log.error("Empty entry: {}", (Object)internal);
                        continue;
                    }
                    byte[] buffer = new byte[size];
                    if (tin.read(buffer) != size) {
                        log.error("Did not read all that was expected {}", (Object)internal);
                        continue;
                    }
                    if (!internal.endsWith(".conf")) {
                        log.error("Not a SWORD config file: {}", (Object)internal);
                        continue;
                    }
                    internal = internal.substring(0, internal.length() - 5);
                    if (internal.startsWith("mods.d/")) {
                        internal = internal.substring(7);
                    }
                    SwordBookMetaData sbmd = new SwordBookMetaData(buffer, internal);
                    sbmd.setDriver(fake);
                    SwordBook book = new SwordBook(sbmd, null);
                    this.entries.put(book.getName(), book);
                }
                catch (IOException ex) {
                    log.error("Failed to load config for entry: {}", (Object)internal, (Object)ex);
                }
            }
            this.loaded = true;
            ConfigEntry.dumpStatistics();
        }
        catch (IOException ex) {
            try {
                throw new InstallException(JSOtherMsg.lookupText("Error loading from cache", new Object[0]), ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(tin);
                IOUtil.close(gin);
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)tin);
        IOUtil.close(gin);
        IOUtil.close(in);
    }

    public String getCatalogDirectory() {
        return this.catalogDirectory;
    }

    public void setCatalogDirectory(String catologDirectory) {
        this.catalogDirectory = catologDirectory;
    }

    public String getPackageDirectory() {
        return this.packageDirectory;
    }

    public void setPackageDirectory(String newDirectory) {
        if (this.packageDirectory == null || !this.packageDirectory.equals(newDirectory)) {
            this.packageDirectory = newDirectory;
            this.loaded = false;
        }
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        if (this.host == null || !this.host.equals(newHost)) {
            this.host = newHost;
            this.loaded = false;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newProxyHost) {
        String pHost = null;
        if (newProxyHost != null && newProxyHost.length() > 0) {
            pHost = newProxyHost;
        }
        if (this.proxyHost == null || !this.proxyHost.equals(pHost)) {
            this.proxyHost = pHost;
            this.loaded = false;
        }
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer newProxyPort) {
        if (this.proxyPort == null || !this.proxyPort.equals(newProxyPort)) {
            this.proxyPort = newProxyPort;
            this.loaded = false;
        }
    }

    protected URI getCachedIndexFile() throws InstallException {
        try {
            URI scratchdir = CWProject.instance().getWriteableProjectSubdir(AbstractSwordInstaller.getTempFileExtension(this.host, this.catalogDirectory), true);
            return NetUtil.lengthenURI(scratchdir, FILE_LIST_GZ);
        }
        catch (IOException ex) {
            throw new InstallException(JSOtherMsg.lookupText("URL manipulation failed", new Object[0]), ex);
        }
    }

    private static String getTempFileExtension(String host, String catalogDir) {
        return DOWNLOAD_PREFIX + host + catalogDir.replace('/', '_');
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractSwordInstaller)) {
            return false;
        }
        AbstractSwordInstaller that = (AbstractSwordInstaller)object;
        if (!this.equals(this.host, that.host)) {
            return false;
        }
        return this.equals(this.packageDirectory, that.packageDirectory);
    }

    @Override
    public int compareTo(AbstractSwordInstaller myClass) {
        int ret = this.host.compareTo(myClass.host);
        if (ret != 0) {
            ret = this.packageDirectory.compareTo(myClass.packageDirectory);
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode() + this.packageDirectory.hashCode();
    }

    protected boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }
}

