/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.icu.DateFormatter;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.sword.AbstractKeyBackend;
import org.crosswire.jsword.book.sword.DataEntry;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.book.sword.state.RawLDBackendState;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;

public class RawLDBackend<T extends RawLDBackendState>
extends AbstractKeyBackend<RawLDBackendState> {
    private static final MessageFormat DATE_KEY_FORMAT = new MessageFormat("{0,number,00}.{1,number,00}");
    private static final Pattern STRONGS_PATTERN = Pattern.compile("^([GH])(\\d+)((!)?([a-z])?)$");
    private final int datasize;
    private final int entrysize;
    private static final int OFFSETSIZE = 4;
    private static final long serialVersionUID = 818089833394450383L;

    public RawLDBackend(SwordBookMetaData sbmd, int datasize) {
        super(sbmd);
        this.datasize = datasize;
        this.entrysize = 4 + datasize;
    }

    @Override
    public String readRawContent(RawLDBackendState state, Key key) throws IOException {
        return this.readRawContent(state, key.getName());
    }

    @Override
    public RawLDBackendState initState() throws BookException {
        return OpenFileStateManager.instance().getRawLDBackendState(this.getBookMetaData());
    }

    private String readRawContent(RawLDBackendState state, String key) throws IOException {
        int pos = this.search(state, key);
        if (pos >= 0) {
            DataEntry entry = this.getEntry(state, key, pos);
            if ((entry = this.getEntry(state, entry)).isLinkEntry()) {
                return this.readRawContent(state, entry.getLinkTarget());
            }
            return this.getRawText(entry);
        }
        throw new IOException(JSMsg.gettext("Key not found {0}", key));
    }

    protected String getRawText(DataEntry entry) {
        String cipherKeyString = this.getBookMetaData().getProperty("CipherKey");
        byte[] cipherKeyBytes = null;
        if (cipherKeyString != null) {
            try {
                cipherKeyBytes = cipherKeyString.getBytes(this.getBookMetaData().getBookCharset());
            }
            catch (UnsupportedEncodingException e) {
                cipherKeyBytes = cipherKeyString.getBytes();
            }
        }
        return entry.getRawText(cipherKeyBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCardinality() {
        RawLDBackendState state = null;
        try {
            state = this.initState();
            if (state.getSize() == -1) {
                state.setSize((int)(state.getIdxRaf().length() / (long)this.entrysize));
            }
            int n = state.getSize();
            return n;
        }
        catch (BookException e) {
            int n = 0;
            return n;
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key get(int index) {
        RawLDBackendState state = null;
        try {
            state = this.initState();
            if (index < this.getCardinality()) {
                DataEntry entry = this.getEntry(state, this.getBookMetaData().getInitials(), index);
                String keytitle = this.internal2external(entry.getKey());
                DefaultLeafKeyList defaultLeafKeyList = new DefaultLeafKeyList(keytitle);
                return defaultLeafKeyList;
            }
        }
        catch (BookException e) {
        }
        catch (IOException iOException) {
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Key that) {
        RawLDBackendState state = null;
        try {
            state = this.initState();
            int n = this.search(state, that.getName());
            return n;
        }
        catch (IOException e) {
            int n = -this.getCardinality() - 1;
            return n;
        }
        catch (BookException e) {
            int n = -this.getCardinality() - 1;
            return n;
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRawTextLength(Key key) {
        RawLDBackendState state = null;
        try {
            state = this.initState();
            int entry = this.search(state, key.getName());
            byte[] buffer = SwordUtil.readRAF(state.getIdxRaf(), entry * this.entrysize, this.entrysize);
            int entrySize = 0;
            switch (this.datasize) {
                case 2: {
                    entrySize = SwordUtil.decodeLittleEndian16(buffer, 4);
                    break;
                }
                case 4: {
                    entrySize = SwordUtil.decodeLittleEndian32(buffer, 4);
                    break;
                }
                default: {
                    assert (false) : this.datasize;
                    break;
                }
            }
            int n = entrySize;
            return n;
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        catch (BookException e) {
            int n = 0;
            return n;
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    private DataIndex getIndex(RawLDBackendState state, long entry) throws IOException {
        byte[] buffer = SwordUtil.readRAF(state.getIdxRaf(), entry * (long)this.entrysize, this.entrysize);
        int entryOffset = SwordUtil.decodeLittleEndian32(buffer, 0);
        int entrySize = -1;
        switch (this.datasize) {
            case 2: {
                entrySize = SwordUtil.decodeLittleEndian16(buffer, 4);
                break;
            }
            case 4: {
                entrySize = SwordUtil.decodeLittleEndian32(buffer, 4);
                break;
            }
            default: {
                assert (false) : this.datasize;
                break;
            }
        }
        return new DataIndex(entryOffset, entrySize);
    }

    private DataEntry getEntry(RawLDBackendState state, String reply, int index) throws IOException {
        DataIndex dataIndex = this.getIndex(state, index);
        byte[] data = SwordUtil.readRAF(state.getDatRaf(), dataIndex.getOffset(), dataIndex.getSize());
        return new DataEntry(reply, data, this.getBookMetaData().getBookCharset());
    }

    protected DataEntry getEntry(RawLDBackendState state, DataEntry entry) {
        return entry;
    }

    private int search(RawLDBackendState state, String key) throws IOException {
        int total = this.getCardinality();
        int low = 0;
        int high = total;
        int match = -1;
        while (high - low > 1) {
            int mid = low + high >>> 1;
            String entryKey = this.normalizeForSearch(this.getEntry(state, key, mid).getKey());
            int cmp = entryKey.compareTo(this.normalizeForSearch(this.external2internal(key, entryKey)));
            if (cmp < 0) {
                low = mid;
                continue;
            }
            if (cmp > 0) {
                high = mid;
                continue;
            }
            match = mid;
            break;
        }
        if (match >= 0) {
            return match;
        }
        if (this.normalizeForSearch(this.getEntry(state, key, 0).getKey()).compareTo(this.normalizeForSearch(key)) == 0) {
            return 0;
        }
        if ("true".equalsIgnoreCase(this.getBookMetaData().getProperty("CaseSensitiveKeys"))) {
            for (int i = 0; i < total; ++i) {
                if (this.getEntry(state, key, i).getKey().compareTo(key) != 0) continue;
                return i;
            }
        }
        return -(high + 1);
    }

    private String external2internal(String externalKey, String pattern) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = externalKey;
        if (BookCategory.DAILY_DEVOTIONS.equals((Object)bmd.getBookCategory())) {
            GregorianCalendar greg = new GregorianCalendar();
            DateFormatter nameDF = DateFormatter.getDateInstance();
            nameDF.setLenient(true);
            Date date = nameDF.parse(keytitle);
            greg.setTime(date);
            Object[] objs = new Object[]{1 + greg.get(2), greg.get(5)};
            return DATE_KEY_FORMAT.format(objs);
        }
        if (bmd.hasFeature(FeatureType.GREEK_DEFINITIONS) || bmd.hasFeature(FeatureType.HEBREW_DEFINITIONS)) {
            Matcher m = STRONGS_PATTERN.matcher(keytitle);
            if (!m.matches()) {
                return keytitle.toUpperCase(Locale.US);
            }
            int pos = keytitle.length() - 1;
            char lastLetter = keytitle.charAt(pos);
            boolean hasTrailingLetter = Character.isLetter(lastLetter);
            if (hasTrailingLetter) {
                keytitle = keytitle.substring(0, pos);
                if (--pos > 0 && keytitle.charAt(pos) == '!') {
                    keytitle = keytitle.substring(0, pos);
                }
            }
            char type = keytitle.charAt(0);
            int strongsNumber = Integer.parseInt(keytitle.substring(1));
            StringBuilder buf = new StringBuilder();
            if (bmd.hasFeature(FeatureType.GREEK_DEFINITIONS) && bmd.hasFeature(FeatureType.HEBREW_DEFINITIONS)) {
                buf.append(Character.toUpperCase(type));
                buf.append(this.getZero4Pad().format(strongsNumber));
                if (hasTrailingLetter && "naslex".equalsIgnoreCase(bmd.getInitials())) {
                    buf.append(Character.toUpperCase(lastLetter));
                }
                return buf.toString();
            }
            m = STRONGS_PATTERN.matcher(pattern);
            if (m.matches()) {
                buf.append(Character.toUpperCase(type));
                int numLength = m.group(2).length();
                if (numLength == 4) {
                    buf.append(this.getZero4Pad().format(strongsNumber));
                } else {
                    buf.append(this.getZero5Pad().format(strongsNumber));
                }
                if (hasTrailingLetter && "naslex".equalsIgnoreCase(bmd.getInitials())) {
                    buf.append(Character.toUpperCase(lastLetter));
                }
                return buf.toString();
            }
            return this.getZero5Pad().format(strongsNumber);
        }
        return keytitle.toUpperCase(Locale.US);
    }

    private String internal2external(String internalKey) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = internalKey;
        if (BookCategory.DAILY_DEVOTIONS.equals((Object)bmd.getBookCategory()) && keytitle.length() >= 3) {
            GregorianCalendar greg = new GregorianCalendar();
            DateFormatter nameDF = DateFormatter.getDateInstance();
            String[] spec = StringUtil.splitAll(keytitle, '.');
            greg.set(2, Integer.parseInt(spec[0]) - 1);
            greg.set(5, Integer.parseInt(spec[1]));
            keytitle = nameDF.format(greg.getTime());
        }
        return keytitle;
    }

    private String normalizeForSearch(String internalKey) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = internalKey;
        String caseSensitive = bmd.getProperty("CaseSensitiveKeys");
        if (!"true".equalsIgnoreCase(caseSensitive) && !BookCategory.DAILY_DEVOTIONS.equals((Object)bmd.getBookCategory())) {
            return keytitle.toUpperCase(Locale.US);
        }
        return keytitle;
    }

    private DecimalFormat getZero5Pad() {
        return new DecimalFormat("00000");
    }

    private DecimalFormat getZero4Pad() {
        return new DecimalFormat("0000");
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
    }
}

