/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.AbstractKeyBackend;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.jdom2.Content;
import org.jdom2.Element;

public class SwordDictionary
extends AbstractBook {
    private Filter filter;

    protected SwordDictionary(SwordBookMetaData sbmd, Backend backend) {
        super(sbmd, backend);
        if (!(backend instanceof AbstractKeyBackend)) {
            throw new IllegalArgumentException("AbstractBackend must be an AbstractKeyBackened");
        }
        this.filter = sbmd.getFilter();
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, boolean allowEmpty, boolean allowGenTitles) throws BookException {
        assert (key != null);
        ArrayList<Object> content = new ArrayList<Object>();
        Element title = OSISUtil.factory().createGeneratedTitle();
        title.addContent(key.getName());
        content.add(title);
        String txt = this.getBackend().getRawText(key);
        List<Content> osisContent = this.filter.toOSIS(this, key, txt);
        content.addAll(osisContent);
        return content.iterator();
    }

    @Override
    public String getRawText(Key key) throws BookException {
        return this.getBackend().getRawText(key);
    }

    @Override
    public boolean contains(Key key) {
        Backend backend = this.getBackend();
        return backend != null && backend.contains(key);
    }

    @Override
    public List<Content> getOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        assert (key != null);
        return this.getBackend().readToOsis(key, processor);
    }

    @Override
    public boolean isWritable() {
        return this.getBackend().isWritable();
    }

    @Override
    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public Key getGlobalKeyList() {
        return (AbstractKeyBackend)this.getBackend();
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public Key getKey(String text) throws NoSuchKeyException {
        AbstractKeyBackend keyBackend = (AbstractKeyBackend)this.getBackend();
        int pos = keyBackend.indexOf(new DefaultLeafKeyList(text));
        if (pos < 0) {
            if (keyBackend.getCardinality() > -pos - 1) {
                return keyBackend.get(-pos - 1);
            }
            return keyBackend.get(keyBackend.getCardinality() - 1);
        }
        return keyBackend.get(pos);
    }

    @Override
    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }
}

