/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.crosswire.common.util.IniSection;
import org.crosswire.jsword.book.sword.SwordBookMetaData;

public class ConfParser {
    private String conf;
    private static final String[] CANONICAL_ORDER = new String[]{"Abbreviation", "Description", "DataPath", "Category", "MinimumVersion", "Lang", "Direction", "Encoding", "SourceType", "ModDrv", "CompressType", "BlockType", "BlockCount", "Versification", "OSISVersion", "OSISqToTick", "KeyType", "DisplayLevel", "Feature", "GlobalOptionFilter", "Siglum1", "Siglum2", "Siglum3", "Siglum4", "Siglum5", "GlossaryFrom", "GlossaryTo", "Font", "Scope", "BookList", "LCSH", "SwordVersionDate", "Version", "History", "Obsoletes", "DistributionLicense", "DistributionSource", "DistributionNotes", "TextSource", "ShortPromo", "CopyrightDate", "ShortCopyright", "About", "Copyright", "CopyrightHolder", "CopyrightContactName", "CopyrightContactAddress", "CopyrightContactEmail", "CopyrightContactNotes", "CopyrightNotes", "InstallSize"};

    public ConfParser(String confFile) {
        this.conf = confFile;
    }

    public void parse() throws IOException {
        File confFile = new File(this.conf);
        if (!confFile.exists()) {
            System.err.println("File does not exist: " + this.conf);
            return;
        }
        IniSection config = new IniSection();
        config.load(confFile, "UTF-8");
        String encoding = config.get("Encoding");
        if (encoding == null || "Latin-1".equalsIgnoreCase(encoding)) {
            config.clear();
            config.load(confFile, "WINDOWS-1252");
        }
        SwordBookMetaData.report(config);
        SwordBookMetaData.normalize(new PrintWriter(System.out), config, CANONICAL_ORDER);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            ConfParser.usage();
            return;
        }
        ConfParser parser = new ConfParser(args[0]);
        try {
            parser.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Usage: ConfParser /full/path/to/xyz.conf");
    }
}

