/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.config.AbstractReflectedChoice;
import org.crosswire.common.config.MappedChoice;
import org.crosswire.common.config.StartupException;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntOptionsChoice
extends AbstractReflectedChoice
implements MappedChoice<Integer, String> {
    private Map<Integer, String> options;

    @Override
    public void init(Element option, ResourceBundle configResources) throws StartupException {
        assert (configResources != null);
        super.init(option, configResources);
        String prefix = this.getKey() + ".alternative.";
        this.options = new TreeMap<Integer, String>();
        for (Element alternative : option.getChildren("alternative")) {
            int number = Integer.parseInt(alternative.getAttributeValue("number"));
            String name = configResources.getString(prefix + number);
            this.options.put(number, name);
        }
    }

    @Override
    public Map<Integer, String> getOptions() {
        return new TreeMap<Integer, String>(this.options);
    }

    public Class<Integer> getConversionClass() {
        return Integer.TYPE;
    }

    @Override
    public String convertToString(Object orig) {
        return orig.toString();
    }

    @Override
    public Object convertToObject(String orig) {
        try {
            return Integer.valueOf(orig);
        }
        catch (NumberFormatException ex) {
            for (Map.Entry<Integer, String> mapEntry : this.options.entrySet()) {
                if (!mapEntry.getValue().equals(orig)) continue;
                return mapEntry.getKey();
            }
            return 0;
        }
    }
}

