/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.config.AbstractReflectedChoice;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.MappedChoice;
import org.crosswire.common.config.StartupException;
import org.crosswire.jsword.JSOtherMsg;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedOptionsChoice
extends AbstractReflectedChoice
implements MappedChoice<Object, Object> {
    private Map<?, ?> options;
    private static Logger log = LoggerFactory.getLogger(MappedOptionsChoice.class);

    @Override
    public void init(Element option, ResourceBundle configResources) throws StartupException {
        assert (configResources != null);
        super.init(option, configResources);
        Element mapElement = option.getChild("map");
        if (mapElement == null) {
            throw new StartupException(JSOtherMsg.lookupText("Missing {0} element in config.xml", "map"));
        }
        String name = mapElement.getAttributeValue("name");
        Object map = ChoiceFactory.getDataMap().get(name);
        this.options = map instanceof Map ? (Map<Object, Object>)map : new TreeMap();
    }

    @Override
    public Map<Object, Object> getOptions() {
        return new TreeMap<Object, Object>(this.options);
    }

    public Class<String> getConversionClass() {
        return String.class;
    }

    @Override
    public String convertToString(Object orig) {
        return orig != null ? orig.toString() : "";
    }

    @Override
    public Object convertToObject(String orig) {
        Iterator<Map.Entry<?, ?>> iter = this.options.entrySet().iterator();
        Map.Entry<?, ?> mapEntry = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            if (!mapEntry.getValue().toString().equals(orig) && !mapEntry.getKey().toString().equals(orig)) continue;
            return mapEntry.getKey().toString();
        }
        log.warn(JSOtherMsg.lookupText("Ignoring invalid option: {0}", orig));
        return "";
    }
}

