/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobManager {
    private static List<WorkListener> listeners = new CopyOnWriteArrayList<WorkListener>();
    private static Set<Progress> jobs = new CopyOnWriteArraySet<Progress>();
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);

    private JobManager() {
    }

    public static Progress createJob(String jobName) {
        return JobManager.createJob(UUID.randomUUID().toString(), jobName, null);
    }

    public static Progress createJob(String jobID, String jobName, Thread workerThread) {
        Job job = new Job(jobID, jobName, workerThread);
        jobs.add(job);
        log.debug("job starting: {}", (Object)job.getJobName());
        return job;
    }

    public static void addWorkListener(WorkListener li) {
        listeners.add(li);
    }

    public static void removeWorkListener(WorkListener li) {
        listeners.remove(li);
    }

    public static Iterator<Progress> iterator() {
        return jobs.iterator();
    }

    public static int getJobCount() {
        return jobs.size();
    }

    protected static void fireWorkProgressed(Progress job) {
        WorkEvent ev = new WorkEvent(job);
        for (WorkListener worker : listeners) {
            worker.workProgressed(ev);
        }
        if (job.isFinished()) {
            log.debug("job finished: {}", (Object)job.getJobName());
            jobs.remove(job);
        }
    }
}

