/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChainLink<E> {
    private E item;
    private boolean head;
    private ChainLink<E> left;
    private ChainLink<E> right;

    public ChainLink() {
        this(null);
    }

    public ChainLink(E item) {
        this.item = item;
        this.head = true;
        this.right = this;
        this.left = this;
    }

    public void setItem(E item) {
        this.item = item;
    }

    public E getItem() {
        return this.item;
    }

    public boolean isHead() {
        return this.head;
    }

    public ChainLink<E> getLeft() {
        return this.left;
    }

    public ChainLink<E> getRight() {
        return this.right;
    }

    public void remove() {
        this.right.head = this.head;
        this.right.left = this.left;
        this.left.right = this.right;
        this.head = true;
        this.right = this;
        this.left = this;
    }

    public void addBefore(ChainLink<E> node) {
        this.head = node.head;
        this.right = node;
        this.left = node.left;
        node.head = false;
        node.left.right = this;
        node.left = this;
    }

    public void addAfter(ChainLink<E> node) {
        this.head = false;
        this.left = node;
        this.right = node.right;
        node.right.left = this;
        node.right = this;
    }

    public ChainLink<E> findHead() {
        ChainLink<E> node = this;
        while (!node.head) {
            node = node.left;
            if (this != node) continue;
            node.head = true;
        }
        return node;
    }

    public ChainLink<E> findTail() {
        return this.findHead().left;
    }

    public void addFirst(ChainLink<E> anyNode) {
        ChainLink<E> node = anyNode.findHead();
        this.addBefore(node);
    }

    public void addLast(ChainLink<E> anyNode) {
        ChainLink<E> node = anyNode.findHead();
        this.addAfter(node.left);
    }

    public ChainLink<E> locate(E element, Comparator<E> comparator) {
        ChainLink<E> node = this;
        int cmp = comparator.compare(element, node.item);
        if (cmp < 0) {
            while (cmp < 0 && !node.head) {
                node = node.left;
                cmp = comparator.compare(element, node.item);
                if (node != this) continue;
                node.head = true;
            }
            return node;
        }
        if (cmp > 0) {
            do {
                node = node.right;
            } while ((cmp = comparator.compare(element, node.item)) > 0 && !node.head && node != this);
            return node;
        }
        return node;
    }
}

