/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.HashMap;
import java.util.Map;

public class Histogram {
    private Map<String, Counter> hist = new HashMap<String, Counter>();

    public void increment(String key) {
        Counter counter = this.hist.get(key);
        if (counter == null) {
            counter = new Counter();
            this.hist.put(key, counter);
        }
        counter.increment();
    }

    public void clear() {
        this.hist.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Counter> entry : this.hist.entrySet()) {
            buf.append(entry.getKey());
            buf.append('\t');
            buf.append(entry.getValue().toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    private static class Counter {
        private int counter;

        Counter() {
        }

        public void increment() {
            ++this.counter;
        }

        public String toString() {
            return Integer.toString(this.counter);
        }
    }
}

