/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.CallContext;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.jsword.JSOtherMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResource(String search) throws MissingResourceException {
        return ResourceUtil.getResource(CallContext.getCallingClass(), search);
    }

    public static <T> URL getResource(Class<T> clazz, String resourceName) throws MissingResourceException {
        URL resource = CWClassLoader.instance(clazz).findResource(resourceName);
        if (resource == null) {
            throw new MissingResourceException(JSOtherMsg.lookupText("Cannot find resource: {0}", resourceName), clazz.getName(), resourceName);
        }
        return resource;
    }

    public static InputStream getResourceAsStream(String search) throws IOException, MissingResourceException {
        return ResourceUtil.getResourceAsStream(CallContext.getCallingClass(), search);
    }

    public static <T> InputStream getResourceAsStream(Class<T> clazz, String search) throws IOException, MissingResourceException {
        return ResourceUtil.getResource(clazz, search).openStream();
    }

    public static PropertyMap getProperties(String subject) throws IOException {
        return ResourceUtil.getProperties(CallContext.getCallingClass(), subject);
    }

    public static <T> PropertyMap getProperties(Class<T> clazz) throws IOException {
        return ResourceUtil.getProperties(clazz, ClassUtil.getShortClassName(clazz));
    }

    private static <T> PropertyMap getProperties(Class<T> clazz, String subject) throws IOException {
        try {
            String lookup = subject + ".properties";
            InputStream in = ResourceUtil.getResourceAsStream(clazz, lookup);
            PropertyMap prop = new PropertyMap();
            prop.load(in);
            return prop;
        }
        catch (MissingResourceException e) {
            return new PropertyMap();
        }
    }
}

