/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackTrace {
    private String[] classNames;
    private String[] methodNames;
    private String[] fileNames;
    private int[] lineNumbers;

    public StackTrace() {
        this.init(new Throwable(), 2);
    }

    public StackTrace(Throwable ex) {
        this.init(ex, 1);
    }

    private void init(Throwable exception, int discard) {
        StringWriter sout = new StringWriter();
        exception.printStackTrace(new PrintWriter(sout));
        String msg = new String(sout.getBuffer());
        String[] calls = StringUtil.split(msg, "\n\r");
        int total = 0;
        for (int i = 0; i < calls.length - discard; ++i) {
            String call = calls[i + discard];
            if (call.startsWith("Caused") || call.indexOf("...") >= 0) continue;
            ++total;
        }
        this.classNames = new String[total];
        this.methodNames = new String[total];
        this.fileNames = new String[total];
        this.lineNumbers = new int[total];
        int j = 0;
        for (int i = 0; i < calls.length - discard; ++i) {
            String call = calls[i + discard];
            boolean oops = false;
            try {
                if (!call.startsWith("Caused") && call.indexOf("...") < 0) {
                    int spcIndex = call.indexOf(32);
                    int lhsIndex = call.indexOf(40);
                    int clnIndex = call.indexOf(58);
                    int rhsIndex = call.indexOf(41);
                    String fullFn = call.substring(spcIndex + 1, lhsIndex).trim();
                    int lastDot = fullFn.lastIndexOf(46);
                    this.classNames[j] = fullFn.substring(0, lastDot).replace('/', '.');
                    this.methodNames[j] = fullFn.substring(lastDot + 1);
                    if (clnIndex != -1 && lhsIndex < clnIndex) {
                        this.fileNames[j] = call.substring(lhsIndex + 1, clnIndex);
                        this.lineNumbers[j] = Integer.parseInt(call.substring(clnIndex + 1, rhsIndex));
                    } else {
                        this.fileNames[j] = call.substring(lhsIndex + 1, rhsIndex);
                        this.lineNumbers[j] = 0;
                    }
                    ++j;
                }
            }
            catch (NumberFormatException ex) {
                oops = true;
            }
            catch (StringIndexOutOfBoundsException ex) {
                oops = true;
            }
            if (!oops) continue;
            this.classNames[j] = "ParseError: ";
            this.methodNames[j] = call;
            this.fileNames[j] = "Error";
            this.lineNumbers[j] = 0;
            ++j;
        }
    }

    public int countStackElements() {
        return this.methodNames.length;
    }

    public String getFunctionName(int level) {
        return this.methodNames[level];
    }

    public String getFullFunctionName(int level) {
        return this.classNames[level] + '.' + this.methodNames[level] + "()";
    }

    public String getClassName(int level) {
        return this.classNames[level];
    }

    public String getFileName(int level) {
        return this.fileNames[level];
    }

    public int getLineNumber(int level) {
        return this.lineNumbers[level];
    }

    public int getClassCount() {
        return this.classNames.length;
    }

    public Class<?> getClass(int level) {
        try {
            return ClassUtil.forName(this.classNames[level]);
        }
        catch (ClassNotFoundException ex) {
            assert (false) : ex;
            return null;
        }
    }

    public Iterator<String> getClassNameElements() {
        return new AbstractStackIterator<String>(){

            @Override
            public String next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getClassName(this.getAndIncrementLevel());
            }
        };
    }

    public Iterator<String> getFunctionNameElements() {
        return new AbstractStackIterator<String>(){

            @Override
            public String next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getFunctionName(this.getAndIncrementLevel());
            }
        };
    }

    public Iterator<String> getFullFunctionNameElements() {
        return new AbstractStackIterator<String>(){

            @Override
            public String next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getFullFunctionName(this.getAndIncrementLevel());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractStackIterator<T>
    implements Iterator<T> {
        private int level;

        @Override
        public boolean hasNext() {
            return this.level < StackTrace.this.getClassCount();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getAndIncrementLevel() throws NoSuchElementException {
            return this.level++;
        }
    }
}

