/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.IOException;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.jsword.book.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookmarkFactory {
    private static Bookmark instance;
    private static final Logger LOGGER;

    private BookmarkFactory() {
    }

    public static Bookmark getBookmark() {
        return instance.clone();
    }

    static {
        LOGGER = LoggerFactory.getLogger(BookmarkFactory.class);
        try {
            instance = PluginUtil.getImplementation(Bookmark.class);
        }
        catch (IOException e) {
            LOGGER.error("createBookmark failed", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOGGER.error("createBookmark failed", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("createBookmark failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("createBookmark failed", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error("createBookmark failed", (Throwable)e);
        }
    }
}

