/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.AbstractBookList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.sword.NullBackend;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookDriver;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSwordInstaller
extends AbstractBookList
implements Installer,
Comparable<AbstractSwordInstaller> {
    protected Map<String, Book> entries = new HashMap<String, Book>();
    protected String host;
    protected String proxyHost;
    protected Integer proxyPort;
    protected String packageDirectory = "";
    protected String catalogDirectory = "";
    protected String indexDirectory = "";
    protected boolean loaded;
    protected static final String FILE_LIST_GZ = "mods.d.tar.gz";
    protected static final String CONF_DIR = "mods.d";
    protected static final String ZIP_SUFFIX = ".zip";
    protected static final String SEARCH_DIR = "search/jsword/L1";
    protected static final String DOWNLOAD_PREFIX = "download-";
    protected static final Logger log = LoggerFactory.getLogger(AbstractSwordInstaller.class);

    protected abstract void download(Progress var1, String var2, String var3, URI var4) throws InstallException;

    @Override
    public String getInstallerDefinition() {
        StringBuilder buf = new StringBuilder(this.host);
        buf.append(',');
        buf.append(this.packageDirectory);
        buf.append(',');
        buf.append(this.catalogDirectory);
        buf.append(',');
        buf.append(this.indexDirectory);
        buf.append(',');
        if (this.proxyHost != null) {
            buf.append(this.proxyHost);
        }
        buf.append(',');
        if (this.proxyPort != null) {
            buf.append(this.proxyPort);
        }
        return buf.toString();
    }

    @Override
    public boolean isNewer(Book book) {
        SwordBookMetaData sbmd = (SwordBookMetaData)book.getBookMetaData();
        File conf = sbmd.getConfigFile();
        if (conf == null || !conf.exists()) {
            return false;
        }
        URI configURI = NetUtil.getURI(conf);
        URI remote = this.toRemoteURI(book);
        return NetUtil.isNewer(remote, configURI, this.proxyHost, this.proxyPort);
    }

    @Override
    public List<Book> getBooks() {
        try {
            if (!this.loaded) {
                this.loadCachedIndex();
            }
            return new ArrayList<Book>(this.entries.values());
        }
        catch (InstallException ex) {
            log.error("Failed to reload cached index file", (Throwable)ex);
            return new ArrayList<Book>();
        }
        catch (IOException ex) {
            log.error("Failed to reload cached index file", (Throwable)ex);
            return new ArrayList<Book>();
        }
        catch (BookException ex) {
            log.error("Failed to reload cached index file", (Throwable)ex);
            return new ArrayList<Book>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Book> getBooks(BookFilter filter) {
        List<Book> books = null;
        AbstractSwordInstaller abstractSwordInstaller = this;
        synchronized (abstractSwordInstaller) {
            books = this.getBooks();
        }
        List<Book> temp = CollectionUtil.createList(new BookFilterIterator(books, filter));
        return new BookSet((Collection<Book>)temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book getBook(String name) {
        BookMetaData bmd;
        List<Book> books = null;
        AbstractSwordInstaller abstractSwordInstaller = this;
        synchronized (abstractSwordInstaller) {
            books = this.getBooks();
        }
        for (Book book : books) {
            if (!name.equals(book.getName())) continue;
            return book;
        }
        for (Book book : books) {
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        for (Book book : books) {
            bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        for (Book book : books) {
            bmd = book.getBookMetaData();
            if (!name.equalsIgnoreCase(bmd.getInitials())) continue;
            return book;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void install(Book book) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadBookList() throws InstallException {
        String jobName = JSMsg.gettext("Downloading files", new Object[0]);
        Progress job = JobManager.createJob("RELOAD_BOOK_LIST", jobName, Thread.currentThread());
        job.beginJob(jobName);
        List<File> errors = null;
        try {
            URI cacheDir = this.getCachedIndexDir();
            URI confDir = NetUtil.lengthenURI(cacheDir, "mods.d.zip");
            URI cache = this.getCachedIndexFile();
            this.download(job, this.catalogDirectory, FILE_LIST_GZ, cache);
            job.setCancelable(false);
            if (NetUtil.isFile(confDir)) {
                String confDirPath = confDir.getPath();
                String confDirPathOld = confDirPath + ".old";
                File dirConf = new File(confDirPath);
                File dirConfOld = new File(confDirPathOld);
                if (dirConfOld.exists()) {
                    FileUtil.delete(dirConfOld);
                }
                if (!dirConf.renameTo(dirConfOld)) {
                    errors = FileUtil.delete(new File(confDirPath));
                }
                if (errors != null && !errors.isEmpty()) {
                    throw new InstallException(JSMsg.gettext("Unable to delete: {0}", errors.get(0)));
                }
                this.unpack(cacheDir, cache);
                FileUtil.delete(dirConfOld);
            }
            this.loaded = false;
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            job.done();
        }
    }

    @Override
    public void downloadSearchIndex(Book book, URI localDest) throws InstallException {
        String jobName = JSMsg.gettext("Downloading files", new Object[0]);
        Progress job = JobManager.createJob(String.format("DOWNLOAD_SEARCH_INDEX-%s", book.getInitials()), jobName, Thread.currentThread());
        job.beginJob(jobName);
        try {
            this.download(job, this.packageDirectory + '/' + SEARCH_DIR, book.getInitials() + ZIP_SUFFIX, localDest);
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpack(URI cacheDir, URI cache) throws IOException {
        InputStream fin = null;
        GzipCompressorInputStream gin = null;
        TarArchiveInputStream tin = null;
        ZipArchiveOutputStream zout = null;
        try {
            ArchiveEntry entry;
            zout = new ZipArchiveOutputStream(new File(cacheDir.getPath(), "mods.d.zip"));
            fin = NetUtil.getInputStream(cache);
            gin = new GzipCompressorInputStream(fin);
            tin = new TarArchiveInputStream((InputStream)gin);
            while ((entry = tin.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String path = entry.getName();
                if (!path.endsWith(".conf")) {
                    log.error("Not a SWORD config file: {}", (Object)path);
                    continue;
                }
                int size = (int)entry.getSize();
                if (size == 0) {
                    log.error("Empty entry: {}", (Object)path);
                    continue;
                }
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(path);
                zout.putArchiveEntry((ArchiveEntry)zipEntry);
                byte[] buffer = new byte[size];
                int n = tin.read(buffer);
                if (n != size) {
                    log.error("Error: Could not read {} bytes for {} from {}", new Object[]{Integer.toString(size), path, cache.getPath()});
                }
                zout.write(buffer, 0, n);
                zout.closeArchiveEntry();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(tin);
            IOUtil.close(gin);
            IOUtil.close(fin);
            IOUtil.close((Closeable)zout);
            throw throwable;
        }
        IOUtil.close((Closeable)tin);
        IOUtil.close((Closeable)gin);
        IOUtil.close(fin);
        IOUtil.close((Closeable)zout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCachedIndex() throws IOException, InstallException, BookException {
        BookDriver fake = SwordBookDriver.instance();
        NullBackend nullBackend = new NullBackend();
        this.entries.clear();
        URI cacheDir = this.getCachedIndexDir();
        URI confDir = NetUtil.lengthenURI(cacheDir, "mods.d.zip");
        URI cache = this.getCachedIndexFile();
        if (!NetUtil.isFile(cache)) {
            this.reloadBookList();
        }
        if (!NetUtil.isFile(confDir)) {
            this.unpack(cacheDir, cache);
        }
        InputStream fin = null;
        ZipArchiveInputStream zin = null;
        try {
            ZipArchiveEntry entry;
            fin = NetUtil.getInputStream(confDir);
            zin = new ZipArchiveInputStream(fin);
            while ((entry = zin.getNextZipEntry()) != null) {
                int offset;
                if (entry.isDirectory()) continue;
                String path = entry.getName();
                if (!path.endsWith(".conf")) {
                    log.error("Not a SWORD config file: {}", (Object)path);
                    continue;
                }
                int size = (int)entry.getSize();
                if (size == 0) {
                    log.error("Empty entry: {}", (Object)path);
                    continue;
                }
                byte[] buffer = new byte[size];
                for (offset = 0; offset < size; offset += zin.read(buffer, offset, size - offset)) {
                }
                if (offset != size) {
                    log.error("Error: Could not read {} bytes, instead {}, for {} from {}", new Object[]{Integer.toString(size), Integer.toString(offset), path, cache.getPath()});
                }
                SwordBookMetaData sbmd = new SwordBookMetaData(buffer, confDir.getPath() + '!' + path);
                sbmd.setDriver(fake);
                if (!sbmd.isSupported()) continue;
                SwordBook book = new SwordBook(sbmd, nullBackend);
                this.entries.put(book.getInitials() + book.getName(), book);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fin);
            IOUtil.close(zin);
            throw throwable;
        }
        IOUtil.close(fin);
        IOUtil.close((Closeable)zin);
        this.loaded = true;
    }

    @Override
    public void close() {
        this.entries.clear();
        this.loaded = false;
    }

    public String getCatalogDirectory() {
        return this.catalogDirectory;
    }

    public void setCatalogDirectory(String catologDirectory) {
        this.catalogDirectory = catologDirectory;
    }

    public String getPackageDirectory() {
        return this.packageDirectory;
    }

    public void setPackageDirectory(String newDirectory) {
        if (this.packageDirectory == null || !this.packageDirectory.equals(newDirectory)) {
            this.packageDirectory = newDirectory;
            this.loaded = false;
        }
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        if (this.host == null || !this.host.equals(newHost)) {
            this.host = newHost;
            this.loaded = false;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newProxyHost) {
        String pHost = null;
        if (newProxyHost != null && newProxyHost.length() > 0) {
            pHost = newProxyHost;
        }
        if (this.proxyHost == null || !this.proxyHost.equals(pHost)) {
            this.proxyHost = pHost;
            this.loaded = false;
        }
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer newProxyPort) {
        if (this.proxyPort == null || !this.proxyPort.equals(newProxyPort)) {
            this.proxyPort = newProxyPort;
            this.loaded = false;
        }
    }

    protected URI getCachedIndexDir() throws InstallException {
        try {
            return CWProject.instance().getWritableProjectSubdir(AbstractSwordInstaller.getTempFileExtension(this.host, this.catalogDirectory), true);
        }
        catch (IOException ex) {
            throw new InstallException(JSOtherMsg.lookupText("URL manipulation failed", new Object[0]), ex);
        }
    }

    protected URI getCachedIndexFile() throws InstallException {
        return NetUtil.lengthenURI(this.getCachedIndexDir(), FILE_LIST_GZ);
    }

    private static String getTempFileExtension(String host, String catalogDir) {
        return DOWNLOAD_PREFIX + host + catalogDir.replace('/', '_');
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractSwordInstaller)) {
            return false;
        }
        AbstractSwordInstaller that = (AbstractSwordInstaller)object;
        if (!StringUtil.equals(this.host, that.host)) {
            return false;
        }
        return StringUtil.equals(this.packageDirectory, that.packageDirectory);
    }

    @Override
    public int compareTo(AbstractSwordInstaller myClass) {
        int ret = this.host.compareTo(myClass.host);
        if (ret != 0) {
            ret = this.packageDirectory.compareTo(myClass.packageDirectory);
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode() + this.packageDirectory.hashCode();
    }
}

