/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.util.regex.Pattern;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerFactory;
import org.crosswire.jsword.book.install.sword.HttpSwordInstaller;

public class HttpSwordInstallerFactory
implements InstallerFactory {
    protected static final String PACKAGE_DIR = "packages/rawzip";
    private static final String LIST_DIR = "raw";
    private Pattern commaPattern = Pattern.compile(",");

    public Installer createInstaller() {
        return new HttpSwordInstaller();
    }

    public Installer createInstaller(String installerDefinition) {
        String[] parts = this.commaPattern.split(installerDefinition, 6);
        switch (parts.length) {
            case 4: {
                return this.createOldInstaller(parts);
            }
            case 6: {
                return this.createInstaller(parts);
            }
        }
        throw new IllegalArgumentException(JSOtherMsg.lookupText("Not enough / symbols in url: {0}", installerDefinition));
    }

    private Installer createInstaller(String[] parts) {
        HttpSwordInstaller reply = new HttpSwordInstaller();
        reply.setHost(parts[0]);
        reply.setPackageDirectory(parts[1]);
        reply.setCatalogDirectory(parts[2]);
        if (parts[3].length() > 0) {
            reply.setProxyHost(parts[3]);
            if (parts[4].length() > 0) {
                reply.setProxyPort(Integer.valueOf(parts[4]));
            }
        }
        return reply;
    }

    private Installer createOldInstaller(String[] parts) {
        HttpSwordInstaller reply = new HttpSwordInstaller();
        reply.setHost(parts[0]);
        reply.setPackageDirectory(parts[1] + '/' + PACKAGE_DIR);
        reply.setCatalogDirectory(parts[1] + '/' + LIST_DIR);
        if (parts[2].length() > 0) {
            reply.setProxyHost(parts[2]);
            if (parts[3].length() > 0) {
                reply.setProxyPort(Integer.valueOf(parts[3]));
            }
        }
        return reply;
    }
}

