/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.AbstractOpenFileState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenBookBackendState
extends AbstractOpenFileState {
    private static final String EXTENSION_BDT = ".bdt";
    private File bdtFile;
    private RandomAccessFile bdtRaf;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenBookBackendState.class);

    GenBookBackendState(BookMetaData bookMetaData) {
        super(bookMetaData);
        URI path = null;
        try {
            path = SwordUtil.getExpandedDataPath(bookMetaData);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, e);
            return;
        }
        this.bdtFile = new File(path.getPath() + EXTENSION_BDT);
        if (!this.bdtFile.canRead()) {
            Reporter.informUser((Object)this, new BookException(JSMsg.gettext("Error reading {0}", this.bdtFile.getAbsolutePath())));
            return;
        }
        try {
            this.bdtRaf = new RandomAccessFile(this.bdtFile, "r");
        }
        catch (IOException ex) {
            IOUtil.close(this.bdtRaf);
            LOGGER.error("failed to open files", (Throwable)ex);
            this.bdtRaf = null;
        }
    }

    public void releaseResources() {
        IOUtil.close(this.bdtRaf);
        this.bdtRaf = null;
    }

    public RandomAccessFile getBdtRaf() {
        return this.bdtRaf;
    }
}

