/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.SerializingContentHandler;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.SwordBookPath;
import org.crosswire.jsword.bridge.BookInstaller;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.versification.BookName;
import org.xml.sax.SAXException;

public class DwrBridge {
    public String[][] getInstalledBooks(String filter) {
        ArrayList<String[]> reply = new ArrayList<String[]>();
        for (Book book : BookInstaller.getInstalledBooks(filter)) {
            String[] rbook = new String[]{book.getInitials(), book.getName()};
            reply.add(rbook);
        }
        if (reply.isEmpty()) {
            reply.add(new String[]{"", "No Books installed"});
        }
        return (String[][])reply.toArray((T[])new String[reply.size()][]);
    }

    public boolean isIndexed(String bookInitials) {
        return this.isBookIndexed(BookInstaller.getInstalledBook(bookInitials));
    }

    public int getCardinality(String bookInitials, String reference) throws NoSuchKeyException {
        Book book = BookInstaller.getInstalledBook(bookInitials);
        if (book != null) {
            Key key = book.getKey(reference);
            return key.getCardinality();
        }
        return 0;
    }

    public String getOSISString(String bookInitials, String reference, int start, int count) throws BookException, NoSuchKeyException {
        String result = "";
        try {
            SAXEventProvider sep = this.getOSISProvider(bookInitials, reference, start, count);
            if (sep != null) {
                SerializingContentHandler ser = new SerializingContentHandler();
                sep.provideSAXEvents(ser);
                result = ((Object)ser).toString();
            }
            return result;
        }
        catch (SAXException ex) {
            return result;
        }
    }

    public String search(String bookInitials, String searchRequest) throws BookException {
        Book book = BookInstaller.getInstalledBook(bookInitials);
        if (this.isBookIndexed(book) && searchRequest != null) {
            if (BookCategory.BIBLE.equals((Object)book.getBookCategory())) {
                BookName.setFullBookName(false);
            }
            return book.find(searchRequest).getName();
        }
        return "";
    }

    public String[] match(String bookInitials, String searchRequest, int maxMatchCount) {
        Book book = BookInstaller.getInstalledBook(bookInitials);
        if (book == null || searchRequest == null || maxMatchCount < 1) {
            return new String[0];
        }
        Locale sortLocale = new Locale(book.getLanguage().getCode());
        String target = searchRequest.toLowerCase(sortLocale);
        String endTarget = target + '\uffff';
        ArrayList<String> result = new ArrayList<String>();
        int count = 0;
        for (Key key : book.getGlobalKeyList()) {
            String entry = key.getName().toLowerCase(sortLocale);
            if (entry.compareTo(target) < 0) continue;
            if (entry.compareTo(endTarget) < 0) {
                result.add(entry);
                ++count;
            }
            if (count < maxMatchCount) continue;
            break;
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getSwordPath() {
        File[] filePath = SwordBookPath.getSwordPath();
        if (filePath.length == 0) {
            return new String[]{"No path"};
        }
        String[] path = new String[filePath.length];
        for (int i = 0; i < filePath.length; ++i) {
            path[i] = filePath[i].getAbsolutePath();
        }
        return path;
    }

    public boolean isBookIndexed(Book book) {
        return book != null && IndexManagerFactory.getIndexManager().isIndexed(book);
    }

    private BookData getBookData(String bookInitials, String reference, int start, int count) throws NoSuchKeyException {
        Book book = BookInstaller.getInstalledBook(bookInitials);
        if (book == null || reference == null || count < 1) {
            return null;
        }
        Key key = null;
        if (BookCategory.BIBLE.equals((Object)book.getBookCategory())) {
            key = book.getKey(reference);
            Passage remainder = (Passage)key;
            if (start > 0) {
                remainder = remainder.trimVerses(start);
            }
            remainder.trimVerses(count);
            key = remainder;
        } else if (BookCategory.GENERAL_BOOK.equals((Object)book.getBookCategory())) {
            key = book.getKey(reference);
        } else {
            key = book.getKey(reference);
            if (start > 0 || key.getCardinality() > count) {
                key = book.createEmptyKeyList();
                int i = 0;
                for (Key aKey : key) {
                    if (++i <= start) continue;
                    if (i >= count) break;
                    key.addAll(aKey);
                }
            }
        }
        return new BookData(book, key);
    }

    private SAXEventProvider getOSISProvider(String bookInitials, String reference, int start, int count) throws BookException, NoSuchKeyException {
        BookData data = this.getBookData(bookInitials, reference, start, count);
        SAXEventProvider provider = null;
        if (data != null) {
            provider = data.getSAXEventProvider();
        }
        return provider;
    }
}

