/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.TreeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GatherAllReferences {
    private static Pattern thmlPassagePattern = Pattern.compile("(osisRef|passage)=\"([^\"]*)");
    private static Pattern gbfPassagePattern = Pattern.compile("(<RX>)([^<]*)");
    private static Pattern osisPassagePattern = Pattern.compile("(osisRef)=\"([^\"]*)");
    private static PrintWriter out;
    private static final Logger log;

    private GatherAllReferences() {
    }

    public static void main(String[] args) throws IOException {
        out = new PrintWriter(new BufferedWriter(new FileWriter("passages.log")));
        log.warn("*** Reading all known Books");
        BookFilter filter = BookFilters.getCustom("GlobalOptionFilter=ThMLScripref;Category=Biblical Texts");
        List<Book> comments = Books.installed().getBooks(filter);
        for (Book book : comments) {
            BookMetaData bmd;
            if (book.isLocked() || (bmd = book.getBookMetaData()).getProperty("SourceType") == null) continue;
            Key set = book.getGlobalKeyList();
            GatherAllReferences.readBook(book, set);
        }
        out.flush();
        out.close();
    }

    private static void readBook(Book book, Key set) {
        int[] stats = new int[]{0, 0};
        boolean first = true;
        for (Key key : set) {
            if (first) {
                first = false;
                if (key instanceof TreeKey && key.getName().length() == 0) continue;
            }
            GatherAllReferences.readKey(book, key, stats);
        }
        log.warn(book.getInitials() + ':' + stats[0] + ':' + stats[1]);
    }

    private static void readKey(Book book, Key key, int[] stats) {
        String orig;
        try {
            orig = book.getRawText(key);
        }
        catch (BookException ex) {
            log.warn("Failed to read: {}({}):{}", new Object[]{book.getInitials(), key.getOsisID(), ex.getMessage(), ex});
            return;
        }
        Matcher matcher = null;
        if (orig.indexOf("passage=\"") != -1) {
            matcher = thmlPassagePattern.matcher(orig);
        } else if (orig.indexOf("osisRef=\"") != -1) {
            matcher = osisPassagePattern.matcher(orig);
        } else if (orig.indexOf("<RX>") != -1) {
            matcher = gbfPassagePattern.matcher(orig);
        }
        if (matcher != null) {
            while (matcher.find()) {
                String rawRef = matcher.group(2);
                stats[0] = stats[0] + 1;
                String message = book.getInitials() + ':' + key.getOsisRef() + '/' + rawRef;
                out.println(message);
            }
        }
    }

    static {
        log = LoggerFactory.getLogger(GatherAllReferences.class);
    }
}

