/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.index.query.QueryDecorator;

public class LuceneQueryDecorator
implements QueryDecorator {
    private static final String SPACE = " ";
    private static final char QUOTE = '\"';
    private static final char PLUS = '+';
    private static final String SPACE_PLUS = " +";
    private static final char MINUS = '-';
    private static final String SPACE_MINUS = " -";
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    private static final char FUZZY = '~';
    private static final String FUZZY_SPACE = "~ ";
    private static final char WILD = '*';
    private static final String WILD_SPACE = "* ";

    public String decorateAllWords(String queryWords) {
        Object[] words = queryWords.split(SPACE);
        StringBuilder search = new StringBuilder();
        search.append('+');
        search.append(StringUtil.join(words, SPACE_PLUS));
        return search.toString();
    }

    public String decorateAnyWords(String queryWords) {
        return queryWords;
    }

    public String decoratePhrase(String queryWords) {
        StringBuilder search = new StringBuilder();
        search.append('\"');
        search.append(queryWords);
        search.append('\"');
        return search.toString();
    }

    public String decorateNotWords(String queryWords) {
        Object[] words = queryWords.split(SPACE);
        StringBuilder search = new StringBuilder();
        search.append('-');
        search.append(StringUtil.join(words, SPACE_MINUS));
        return search.toString();
    }

    public String decorateRange(String queryWords) {
        StringBuilder search = new StringBuilder();
        search.append('+');
        search.append('[');
        search.append(queryWords);
        search.append(']');
        return search.toString();
    }

    public String decorateSpellWords(String queryWords) {
        Object[] words = queryWords.split(SPACE);
        StringBuilder search = new StringBuilder(StringUtil.join(words, FUZZY_SPACE));
        search.append('~');
        return search.toString();
    }

    public String decorateStartWords(String queryWords) {
        Object[] words = queryWords.split(SPACE);
        StringBuilder search = new StringBuilder(StringUtil.join(words, WILD_SPACE));
        search.append('*');
        return search.toString();
    }
}

