/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.study.StrongsNumber;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookTokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongsNumberFilter
extends AbstractBookTokenFilter {
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private StrongsNumber number;
    private static final Logger log = LoggerFactory.getLogger(StrongsNumberFilter.class);

    public StrongsNumberFilter(TokenStream in) {
        this(null, in);
    }

    public StrongsNumberFilter(Book book, TokenStream in) {
        super(book, in);
    }

    public boolean incrementToken() throws IOException {
        if (this.number == null) {
            while (this.input.incrementToken()) {
                String tokenText = this.termAtt.term();
                this.number = new StrongsNumber(tokenText);
                if (!this.number.isValid()) {
                    log.warn(JSMsg.gettext("Not a valid Strong's Number \"{0}\"", tokenText));
                    continue;
                }
                String s = this.number.getStrongsNumber();
                this.termAtt.setTermBuffer(s);
                if (!this.number.isPart()) {
                    this.number = null;
                }
                return true;
            }
            return false;
        }
        this.termAtt.setTermBuffer(this.number.getFullStrongsNumber());
        this.number = null;
        return true;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

