/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.passage.VerseRangeFactory;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPassage
implements Passage {
    private static final Logger log = LoggerFactory.getLogger(AbstractPassage.class);
    protected static final int BITWISE = 0;
    protected static final int DISTINCT = 1;
    protected static final int RANGED = 2;
    protected static final int METHOD_COUNT = 3;
    private transient Versification v11n;
    private transient Key parent;
    protected transient List<PassageListener> listeners;
    protected transient String originalName;
    protected transient int suppressEvents;
    protected transient int skipNormalization;
    public static final String REF_ALLOWED_DELIMS = ",;\n\r\t";
    public static final String REF_PREF_DELIM = ", ";
    public static final String REF_OSIS_DELIM = " ";
    private static final long serialVersionUID = -5931560451407396276L;

    protected AbstractPassage(Versification v11n) {
        this(v11n, null);
    }

    protected AbstractPassage(Versification v11n, String passageName) {
        this.v11n = v11n;
        this.originalName = passageName;
        this.listeners = new ArrayList<PassageListener>();
    }

    @Override
    public Versification getVersification() {
        return this.v11n;
    }

    @Override
    public Passage reversify(Versification newVersification) {
        if (this.v11n.equals(newVersification)) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWhole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Passage getWhole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Key obj) {
        Passage thatref = (Passage)obj;
        if (thatref.countVerses() == 0) {
            if (this.countVerses() == 0) {
                return 0;
            }
            return -1;
        }
        if (this.countVerses() == 0) {
            return 1;
        }
        Verse thatfirst = thatref.getVerseAt(0);
        Verse thisfirst = this.getVerseAt(0);
        return this.getVersification().distance(thatfirst, thisfirst);
    }

    @Override
    public AbstractPassage clone() {
        AbstractPassage copy;
        block2: {
            copy = null;
            try {
                copy = (AbstractPassage)super.clone();
                copy.listeners = new ArrayList<PassageListener>();
                copy.listeners.addAll(this.listeners);
                copy.originalName = this.originalName;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Passage)) {
            return false;
        }
        Passage that = (Passage)obj;
        return that.getOsisRef().equals(this.getOsisRef());
    }

    @Override
    public int hashCode() {
        return this.getOsisRef().hashCode();
    }

    @Override
    public String getName() {
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        StringBuilder retcode = new StringBuilder();
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        Verse current = null;
        while (it.hasNext()) {
            VerseRange range = it.next();
            retcode.append(range.getName(current));
            if (it.hasNext()) {
                retcode.append(REF_PREF_DELIM);
            }
            current = range.getStart();
        }
        return retcode.toString();
    }

    @Override
    public String getName(Key base) {
        return this.getName();
    }

    @Override
    public String getRootName() {
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        if (it.hasNext()) {
            VerseRange range = it.next();
            return range.getRootName();
        }
        return this.getName();
    }

    @Override
    public String getOsisRef() {
        StringBuilder retcode = new StringBuilder();
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Key range = it.next();
            retcode.append(range.getOsisRef());
            hasNext = it.hasNext();
            if (!hasNext) continue;
            retcode.append(REF_OSIS_DELIM);
        }
        return retcode.toString();
    }

    @Override
    public String getOsisID() {
        StringBuilder retcode = new StringBuilder();
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Key range = it.next();
            retcode.append(range.getOsisID());
            hasNext = it.hasNext();
            if (!hasNext) continue;
            retcode.append(REF_OSIS_DELIM);
        }
        return retcode.toString();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getOverview() {
        return JSMsg.gettext("{0,number,integer} {0,choice,0#verses|1#verse|1<verses} in {1,number,integer} {1,choice,0#books|1#book|1<books}", this.countVerses(), this.booksInPassage());
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public int countVerses() {
        int count = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    @Override
    public boolean hasRanges(RestrictionType restrict) {
        int count = 0;
        Iterator<VerseRange> it = this.rangeIterator(restrict);
        while (it.hasNext()) {
            it.next();
            if (++count != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countRanges(RestrictionType restrict) {
        int count = 0;
        Iterator<VerseRange> it = this.rangeIterator(restrict);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public int booksInPassage() {
        BibleBook currentBook = null;
        int bookCount = 0;
        for (Key aKey : this) {
            Verse verse = (Verse)aKey;
            if (currentBook == verse.getBook()) continue;
            currentBook = verse.getBook();
            ++bookCount;
        }
        return bookCount;
    }

    @Override
    public Verse getVerseAt(int offset) throws ArrayIndexOutOfBoundsException {
        Iterator it = this.iterator();
        Object retcode = null;
        for (int i = 0; i <= offset; ++i) {
            if (!it.hasNext()) {
                throw new ArrayIndexOutOfBoundsException(JSOtherMsg.lookupText("Index out of range (Given {0,number,integer}, Max {1,number,integer}).", offset, this.countVerses()));
            }
            retcode = it.next();
        }
        return retcode;
    }

    @Override
    public VerseRange getRangeAt(int offset, RestrictionType restrict) throws ArrayIndexOutOfBoundsException {
        Iterator<VerseRange> it = this.rangeIterator(restrict);
        VerseRange retcode = null;
        for (int i = 0; i <= offset; ++i) {
            if (!it.hasNext()) {
                throw new ArrayIndexOutOfBoundsException(JSOtherMsg.lookupText("Index out of range (Given {0,number,integer}, Max {1,number,integer}).", offset, this.countVerses()));
            }
            retcode = it.next();
        }
        return retcode;
    }

    @Override
    public Iterator<VerseRange> rangeIterator(RestrictionType restrict) {
        return new VerseRangeIterator(this.getVersification(), this.iterator(), restrict);
    }

    @Override
    public boolean containsAll(Passage that) {
        if (that instanceof RangedPassage) {
            Iterator<VerseRange> iter = null;
            iter = ((RangedPassage)that).rangeIterator(RestrictionType.NONE);
            while (iter.hasNext()) {
                if (this.contains(iter.next())) continue;
                return false;
            }
        } else {
            Iterator iter = that.iterator();
            while (iter.hasNext()) {
                if (this.contains((Key)iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Passage trimVerses(int count) {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        int i = 0;
        boolean overflow = false;
        AbstractPassage remainder = this.clone();
        for (Key verse : this) {
            if (++i > count) {
                this.remove(verse);
                overflow = true;
                continue;
            }
            remainder.remove(verse);
        }
        this.lowerNormalizeProtection();
        if (overflow) {
            return remainder;
        }
        return null;
    }

    @Override
    public Passage trimRanges(int count, RestrictionType restrict) {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        int i = 0;
        boolean overflow = false;
        AbstractPassage remainder = this.clone();
        Iterator<VerseRange> it = this.rangeIterator(restrict);
        while (it.hasNext()) {
            Key range = it.next();
            if (++i > count) {
                this.remove(range);
                overflow = true;
                continue;
            }
            remainder.remove(range);
        }
        this.lowerNormalizeProtection();
        if (overflow) {
            return remainder;
        }
        return null;
    }

    @Override
    public void addAll(Key key) {
        if (key.isEmpty()) {
            return;
        }
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        if (key instanceof RangedPassage) {
            Iterator<VerseRange> it = ((RangedPassage)key).rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                this.add(it.next());
            }
        } else {
            for (Key subkey : key) {
                this.add(subkey);
            }
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            VerseKey<Passage> that;
            if (key instanceof Passage) {
                that = (Passage)key;
                this.fireIntervalAdded(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
            } else if (key instanceof VerseRange) {
                that = (VerseRange)key;
                this.fireIntervalAdded(this, ((VerseRange)that).getStart(), ((VerseRange)that).getEnd());
            } else if (key instanceof Verse) {
                that = (Verse)key;
                this.fireIntervalAdded(this, (Verse)that, (Verse)that);
            }
        }
    }

    @Override
    public void removeAll(Key key) {
        Iterator<Object> it;
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        if (key instanceof RangedPassage) {
            it = ((RangedPassage)key).rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                this.remove((Key)it.next());
            }
        } else {
            it = key.iterator();
            while (it.hasNext()) {
                this.remove((Key)it.next());
            }
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            VerseKey<Passage> that;
            if (key instanceof Passage) {
                that = (Passage)key;
                this.fireIntervalRemoved(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
            } else if (key instanceof VerseRange) {
                that = (VerseRange)key;
                this.fireIntervalRemoved(this, ((VerseRange)that).getStart(), ((VerseRange)that).getEnd());
            } else if (key instanceof Verse) {
                that = (Verse)key;
                this.fireIntervalRemoved(this, (Verse)that, (Verse)that);
            }
        }
    }

    @Override
    public void retainAll(Key key) {
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        AbstractPassage temp = this.clone();
        for (Key verse : temp) {
            if (key.contains(verse)) continue;
            this.remove(verse);
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            this.fireIntervalRemoved(this, null, null);
        }
    }

    @Override
    public void clear() {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        this.remove(this.getVersification().getAllVerses());
        if (this.lowerEventSuppressionAndTest()) {
            this.fireIntervalRemoved(this, null, null);
        }
    }

    @Override
    public void blur(int verses, RestrictionType restrict) {
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        AbstractPassage temp = this.clone();
        Iterator<VerseRange> it = temp.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange range = restrict.blur(this.getVersification(), it.next(), verses, verses);
            this.add(range);
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            this.fireIntervalAdded(this, null, null);
        }
    }

    @Override
    public void writeDescription(Writer out) throws IOException {
        BufferedWriter bout = new BufferedWriter(out);
        bout.write(this.v11n.getName());
        bout.newLine();
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            Key range = it.next();
            bout.write(range.getName());
            bout.newLine();
        }
        bout.flush();
    }

    @Override
    public void readDescription(Reader in) throws IOException, NoSuchVerseException {
        String line;
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        int count = 0;
        BufferedReader bin = new BufferedReader(in, 8192);
        String v11nName = bin.readLine();
        this.v11n = Versifications.instance().getVersification(v11nName);
        while ((line = bin.readLine()) != null) {
            ++count;
            this.addVerses(line, null);
        }
        if (count == 0) {
            return;
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            this.fireIntervalAdded(this, this.getVerseAt(0), this.getVerseAt(this.countVerses() - 1));
        }
    }

    @Override
    public void optimizeReads() {
    }

    protected void optimizeWrites() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPassageListener(PassageListener li) {
        List<PassageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePassageListener(PassageListener li) {
        List<PassageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(li);
        }
    }

    @Override
    public boolean contains(Key key) {
        Passage ref = KeyUtil.getPassage(key);
        return this.containsAll(ref);
    }

    @Override
    public int getCardinality() {
        return this.countVerses();
    }

    @Override
    public int indexOf(Key that) {
        int index = 0;
        for (Key key : this) {
            if (((Object)key).equals(that)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Key get(int index) {
        return this.getVerseAt(index);
    }

    @Override
    public Key getParent() {
        return this.parent;
    }

    public void setParent(Key parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIntervalAdded(Object source, Verse start, Verse end) {
        ArrayList<PassageListener> temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, PassageEvent.EventType.ADDED, start, end);
        List<PassageListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<PassageListener>();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesAdded(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIntervalRemoved(Object source, Verse start, Verse end) {
        ArrayList<PassageListener> temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, PassageEvent.EventType.REMOVED, start, end);
        List<PassageListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<PassageListener>();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesRemoved(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentsChanged(Object source, Verse start, Verse end) {
        ArrayList<PassageListener> temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, PassageEvent.EventType.CHANGED, start, end);
        List<PassageListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<PassageListener>();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesChanged(ev);
        }
    }

    protected void addVerses(String refs, Key basis) throws NoSuchVerseException {
        this.optimizeWrites();
        String[] parts = StringUtil.split(refs, REF_ALLOWED_DELIMS);
        if (parts.length == 0) {
            return;
        }
        int start = 0;
        VerseRange vrBasis = null;
        if (basis instanceof Verse) {
            vrBasis = new VerseRange(this.v11n, (Verse)basis);
        } else if (basis instanceof VerseRange) {
            vrBasis = (VerseRange)basis;
        } else {
            vrBasis = VerseRangeFactory.fromString(this.v11n, parts[0].trim());
            this.add(vrBasis);
            start = 1;
        }
        for (int i = start; i < parts.length; ++i) {
            VerseRange next = VerseRangeFactory.fromString(this.v11n, parts[i].trim(), vrBasis);
            this.add(next);
            vrBasis = next;
        }
    }

    void normalize() {
    }

    public void raiseNormalizeProtection() {
        ++this.skipNormalization;
        if (this.skipNormalization > 10) {
            log.warn("skip_normalization={}", (Object)Integer.toString(this.skipNormalization));
        }
    }

    public void lowerNormalizeProtection() {
        --this.skipNormalization;
        if (this.skipNormalization == 0) {
            this.normalize();
        }
        assert (this.skipNormalization >= 0);
    }

    public void raiseEventSuppresion() {
        ++this.suppressEvents;
        if (this.suppressEvents > 10) {
            log.warn("suppress_events={}", (Object)Integer.toString(this.suppressEvents));
        }
    }

    public boolean lowerEventSuppressionAndTest() {
        --this.suppressEvents;
        assert (this.suppressEvents >= 0);
        return this.suppressEvents == 0;
    }

    protected static VerseRange toVerseRange(Versification v11n, Object base) throws ClassCastException {
        assert (base != null);
        if (base instanceof VerseRange) {
            return (VerseRange)base;
        }
        if (base instanceof Verse) {
            return new VerseRange(v11n, (Verse)base);
        }
        throw new ClassCastException(JSOtherMsg.lookupText("Can only use Verses and VerseRanges in this Collection", new Object[0]));
    }

    protected void writeObjectSupport(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.v11n.getName());
        int bitwiseSize = this.v11n.maximumOrdinal();
        int rangedSize = 8 * this.countRanges(RestrictionType.NONE);
        int distinctSize = 4 * this.countVerses();
        if (bitwiseSize <= rangedSize && bitwiseSize <= distinctSize) {
            out.writeInt(0);
            BitSet store = new BitSet(bitwiseSize);
            for (Verse verse : this) {
                store.set(verse.getOrdinal());
            }
            out.writeObject(store);
        } else if (distinctSize <= rangedSize) {
            out.writeInt(1);
            out.writeInt(this.countVerses());
            for (Key aKey : this) {
                Verse verse = (Verse)aKey;
                out.writeInt(verse.getOrdinal());
            }
        } else {
            out.writeInt(2);
            out.writeInt(this.countRanges(RestrictionType.NONE));
            Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                VerseRange range = it.next();
                out.writeInt(range.getStart().getOrdinal());
                out.writeInt(range.getCardinality());
            }
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listeners = new ArrayList<PassageListener>();
        this.originalName = null;
        this.parent = null;
        this.skipNormalization = 0;
        this.suppressEvents = 0;
        is.defaultReadObject();
    }

    protected void readObjectSupport(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        String v11nName = is.readUTF();
        this.v11n = Versifications.instance().getVersification(v11nName);
        int type = is.readInt();
        switch (type) {
            case 0: {
                BitSet store = (BitSet)is.readObject();
                for (int i = 0; i < this.v11n.maximumOrdinal(); ++i) {
                    if (!store.get(i)) continue;
                    this.add(this.v11n.decodeOrdinal(i));
                }
                break;
            }
            case 1: {
                int verses = is.readInt();
                for (int i = 0; i < verses; ++i) {
                    int ord = is.readInt();
                    this.add(this.v11n.decodeOrdinal(ord));
                }
                break;
            }
            case 2: {
                int ranges = is.readInt();
                for (int i = 0; i < ranges; ++i) {
                    int ord = is.readInt();
                    int count = is.readInt();
                    this.add(RestrictionType.NONE.toRange(this.getVersification(), this.v11n.decodeOrdinal(ord), count));
                }
                break;
            }
            default: {
                throw new ClassCastException(JSOtherMsg.lookupText("Can only use Verses and VerseRanges in this Collection", new Object[0]));
            }
        }
        this.lowerEventSuppressionAndTest();
        this.lowerNormalizeProtection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class VerseRangeIterator
    implements Iterator<VerseRange> {
        private Versification v11n;
        private Iterator<Key> it;
        private VerseRange nextRange;
        private Verse nextVerse;
        private RestrictionType restrict;

        protected VerseRangeIterator(Versification v11n, Iterator<Key> it, RestrictionType restrict) {
            this.v11n = v11n;
            this.it = it;
            this.restrict = restrict;
            if (it.hasNext()) {
                this.nextVerse = (Verse)it.next();
            }
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextRange != null;
        }

        @Override
        public VerseRange next() throws NoSuchElementException {
            VerseRange retcode = this.nextRange;
            if (retcode == null) {
                throw new NoSuchElementException();
            }
            this.calculateNext();
            return retcode;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void calculateNext() {
            if (this.nextVerse == null) {
                this.nextRange = null;
                return;
            }
            Verse start = this.nextVerse;
            Verse end = this.nextVerse;
            while (true) {
                if (!this.it.hasNext()) {
                    this.nextVerse = null;
                    break;
                }
                this.nextVerse = (Verse)this.it.next();
                if (!this.v11n.isAdjacentVerse(end, this.nextVerse) || !this.restrict.isSameScope(this.v11n, end, this.nextVerse)) break;
                end = this.nextVerse;
            }
            this.nextRange = new VerseRange(this.v11n, start, end);
        }
    }
}

