/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.util.ItemIterator;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.BibleNames;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Verse
implements VerseKey<Verse> {
    public static final char VERSE_OSIS_DELIM = '.';
    public static final char VERSE_OSIS_SUB_PREFIX = '!';
    public static final char VERSE_PREF_DELIM1 = ' ';
    public static final char VERSE_PREF_DELIM2 = ':';
    public static final Verse DEFAULT = new Verse(Versifications.instance().getVersification("KJV"), BibleBook.GEN, 1, 1);
    private static NumberShaper shaper = new NumberShaper();
    private transient Versification v11n;
    private int ordinal;
    private transient BibleBook book;
    private transient int chapter;
    private transient int verse;
    private String subIdentifier;
    private static final Logger log = LoggerFactory.getLogger(Verse.class);
    private static final long serialVersionUID = -4033921076023185171L;

    public Verse(Versification v11n, BibleBook book, int chapter, int verse) {
        this(v11n, book, chapter, verse, null);
    }

    public Verse(Versification v11n, BibleBook book, int chapter, int verse, String subIdentifier) {
        this.v11n = v11n;
        this.book = book;
        this.chapter = chapter;
        this.verse = verse;
        this.subIdentifier = subIdentifier;
        this.ordinal = v11n.getOrdinal(this);
    }

    public Verse(Versification v11n, BibleBook book, int chapter, int verse, boolean patchUp) {
        if (!patchUp) {
            throw new IllegalArgumentException(JSOtherMsg.lookupText("Use patchUp=true.", new Object[0]));
        }
        this.v11n = v11n;
        Verse patched = this.v11n.patch(book, chapter, verse);
        this.book = patched.book;
        this.chapter = patched.chapter;
        this.verse = patched.verse;
        this.ordinal = patched.ordinal;
    }

    public Verse(Versification v11n, int ordinal) {
        Verse decoded = v11n.decodeOrdinal(ordinal);
        this.v11n = v11n;
        this.book = decoded.book;
        this.chapter = decoded.chapter;
        this.verse = decoded.verse;
        this.ordinal = decoded.ordinal;
    }

    @Override
    public boolean isWhole() {
        return this.subIdentifier == null || this.subIdentifier.length() == 0;
    }

    @Override
    public Verse getWhole() {
        if (this.isWhole()) {
            return this;
        }
        return new Verse(this.v11n, this.book, this.chapter, this.verse);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getName(Key base) {
        if (base != null && !(base instanceof Verse)) {
            return this.getName();
        }
        String verseName = this.doGetName((Verse)base);
        if (shaper.canUnshape()) {
            return shaper.shape(verseName);
        }
        return verseName;
    }

    @Override
    public String getRootName() {
        return BibleNames.instance().getShortName(this.book);
    }

    @Override
    public String getOsisRef() {
        return this.getOsisID();
    }

    @Override
    public String getOsisID() {
        StringBuilder buf = this.getVerseIdentifier();
        if (this.subIdentifier != null && this.subIdentifier.length() > 0) {
            buf.append('!');
            buf.append(this.subIdentifier);
        }
        return buf.toString();
    }

    public String getOsisIDNoSubIdentifier() {
        return this.getVerseIdentifier().toString();
    }

    private StringBuilder getVerseIdentifier() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.book.getOSIS());
        buf.append('.');
        buf.append(this.chapter);
        buf.append('.');
        buf.append(this.verse);
        return buf;
    }

    @Override
    public Verse clone() {
        Verse copy;
        block2: {
            copy = null;
            try {
                copy = (Verse)super.clone();
                copy.v11n = this.v11n;
                copy.book = this.book;
                copy.chapter = this.chapter;
                copy.verse = this.verse;
                copy.ordinal = this.ordinal;
                copy.subIdentifier = this.subIdentifier;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Verse)) {
            return false;
        }
        Verse that = (Verse)obj;
        return this.ordinal == that.ordinal && this.v11n.equals(that.v11n) && Verse.bothNullOrEqual(this.subIdentifier, that.subIdentifier);
    }

    @Override
    public int hashCode() {
        int result = 31 + this.ordinal;
        result = 31 * result + (this.v11n == null ? 0 : this.v11n.hashCode());
        return 31 * result + (this.subIdentifier == null ? 0 : this.subIdentifier.hashCode());
    }

    @Override
    public int compareTo(Key obj) {
        return this.ordinal - ((Verse)obj).ordinal;
    }

    @Override
    public Versification getVersification() {
        return this.v11n;
    }

    @Override
    public Verse reversify(Versification newVersification) {
        if (this.v11n.equals(newVersification)) {
            return this;
        }
        try {
            if (newVersification.validate(this.book, this.chapter, this.verse, true)) {
                return new Verse(newVersification, this.book, this.chapter, this.verse);
            }
        }
        catch (NoSuchVerseException ex) {
            log.error("Contract for validate was changed to thrown an exception when silent mode is true", (Throwable)ex);
        }
        return null;
    }

    public BibleBook getBook() {
        return this.book;
    }

    public int getChapter() {
        return this.chapter;
    }

    public int getVerse() {
        return this.verse;
    }

    public String getSubIdentifier() {
        return this.subIdentifier;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Verse[] toVerseArray() {
        return new Verse[]{this};
    }

    @Override
    public Key getParent() {
        return null;
    }

    public static boolean bothNullOrEqual(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    private String doGetName(Verse verseBase) {
        StringBuilder buf = new StringBuilder();
        if (this.book.isShortBook()) {
            if (verseBase == null || verseBase.book != this.book) {
                buf.append(BibleNames.instance().getPreferredName(this.book));
                buf.append(' ');
                buf.append(this.verse);
                return buf.toString();
            }
            return Integer.toString(this.verse);
        }
        if (verseBase == null || verseBase.book != this.book) {
            buf.append(BibleNames.instance().getPreferredName(this.book));
            buf.append(' ');
            buf.append(this.chapter);
            buf.append(':');
            buf.append(this.verse);
            return buf.toString();
        }
        if (verseBase.chapter != this.chapter) {
            buf.append(this.chapter);
            buf.append(':');
            buf.append(this.verse);
            return buf.toString();
        }
        return Integer.toString(this.verse);
    }

    protected static int parseInt(String text) throws NoSuchVerseException {
        try {
            return Integer.parseInt(shaper.unshape(text));
        }
        catch (NumberFormatException ex) {
            throw new NoSuchVerseException(JSMsg.gettext("Cannot understand {0} as a chapter or verse.", text));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.v11n.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String v11nName = in.readUTF();
        this.v11n = Versifications.instance().getVersification(v11nName);
        Verse decoded = this.v11n.decodeOrdinal(this.ordinal);
        this.book = decoded.book;
        this.chapter = decoded.chapter;
        this.verse = decoded.verse;
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Key key) {
        return this.equals(key);
    }

    @Override
    public Iterator<Key> iterator() {
        return new ItemIterator<Key>(this);
    }

    @Override
    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
    }

    @Override
    public Key get(int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    public int indexOf(Key that) {
        if (this.equals(that)) {
            return 0;
        }
        return -1;
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
        throw new UnsupportedOperationException();
    }
}

