/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;

public class BookFilterIterator
implements Iterable<Book>,
Iterator<Book> {
    private Book next;
    private Iterator<Book> it;
    private BookFilter filter;

    public BookFilterIterator(List<Book> books, BookFilter filter) {
        this.it = books.iterator();
        this.filter = filter;
    }

    @Override
    public Iterator<Book> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.next = this.findNext();
        return this.next != null;
    }

    @Override
    public Book next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Book findNext() {
        while (this.it.hasNext()) {
            Book book = this.it.next();
            if (this.filter != null && !this.filter.test(book)) continue;
            return book;
        }
        return null;
    }
}

