/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.AbstractBookList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Books
extends AbstractBookList {
    private BookSet books = new BookSet();
    private Set<BookDriver> drivers = new HashSet<BookDriver>();
    private static final Logger log = LoggerFactory.getLogger(Books.class);
    private static final Books instance = new Books();

    private Books() {
    }

    public static Books installed() {
        return instance;
    }

    @Override
    public synchronized List<Book> getBooks() {
        return new BookSet(this.books);
    }

    public synchronized Book getBook(String name) {
        if (name == null) {
            return null;
        }
        for (Book book : this.books) {
            if (!name.equals(book.getName())) continue;
            return book;
        }
        for (Book book : this.books) {
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        for (Book book : this.books) {
            BookMetaData bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        for (Book book : this.books) {
            if (!name.equalsIgnoreCase(book.getInitials())) continue;
            return book;
        }
        return null;
    }

    @Override
    public synchronized List<Book> getBooks(BookFilter filter) {
        List<Book> temp = CollectionUtil.createList(new BookFilterIterator(this.getBooks(), filter));
        return new BookSet((Collection<Book>)temp);
    }

    public int getMaxLength(String propertyKey) {
        int max = -1;
        for (Book book : this.getBooks()) {
            Object property = book.getProperty(propertyKey);
            if (property == null) continue;
            String value = property instanceof String ? (String)property : property.toString();
            max = Math.max(max, value.length());
        }
        return max;
    }

    public int getMaxLength(String propertyKey, BookFilter filter) {
        int max = -1;
        for (Book book : this.getBooks(filter)) {
            Object property = book.getProperty(propertyKey);
            if (property == null) continue;
            String value = property instanceof String ? (String)property : property.toString();
            max = Math.max(max, value.length());
        }
        return max;
    }

    public synchronized void addBook(Book book) {
        this.books.add(book);
        this.fireBooksChanged(instance, book, true);
    }

    public synchronized void removeBook(Book book) throws BookException {
        Activator.deactivate(book);
        boolean removed = this.books.remove(book);
        if (!removed) {
            throw new BookException(JSOtherMsg.lookupText("Could not remove unregistered Book: {0}", book.getName()));
        }
        this.fireBooksChanged(instance, book, false);
    }

    public synchronized void registerDriver(BookDriver driver) throws BookException {
        log.debug("begin registering driver: {}", (Object)driver.getClass().getName());
        this.drivers.add(driver);
        Book[] bookArray = driver.getBooks();
        Set<Book> current = CollectionUtil.createSet(new BookFilterIterator(this.getBooks(), BookFilters.getBooksByDriver(driver)));
        for (int j = 0; j < bookArray.length; ++j) {
            Book b = bookArray[j];
            if (current.contains(b)) {
                current.remove(b);
                continue;
            }
            this.addBook(bookArray[j]);
        }
        for (Book book : current) {
            this.removeBook(book);
        }
        log.debug("end registering driver: {}", (Object)driver.getClass().getName());
    }

    public synchronized void unregisterDriver(BookDriver driver) throws BookException {
        log.debug("begin un-registering driver: {}", (Object)driver.getClass().getName());
        Book[] bookArray = driver.getBooks();
        for (int j = 0; j < bookArray.length; ++j) {
            this.removeBook(bookArray[j]);
        }
        if (!this.drivers.remove(driver)) {
            throw new BookException(JSOtherMsg.lookupText("Could not remove unregistered Driver: {0}", driver.getClass().getName()));
        }
        log.debug("end un-registering driver: {}", (Object)driver.getClass().getName());
    }

    public synchronized BookDriver[] getDriversByClass(Class<? extends BookDriver> type) {
        ArrayList<BookDriver> matches = new ArrayList<BookDriver>();
        for (BookDriver driver : this.drivers) {
            if (driver.getClass() != type) continue;
            matches.add(driver);
        }
        return matches.toArray(new BookDriver[matches.size()]);
    }

    public synchronized BookDriver[] getDrivers() {
        return this.drivers.toArray(new BookDriver[this.drivers.size()]);
    }

    public synchronized BookDriver[] getWritableDrivers() {
        int i = 0;
        for (BookDriver driver : this.drivers) {
            if (!driver.isWritable()) continue;
            ++i;
        }
        BookDriver[] reply = new BookDriver[i];
        i = 0;
        for (BookDriver driver : this.drivers) {
            if (!driver.isWritable()) continue;
            reply[i++] = driver;
        }
        return reply;
    }

    private void autoRegister() {
        Class<BookDriver>[] types = PluginUtil.getImplementors(BookDriver.class);
        log.debug("begin auto-registering {} drivers:", (Object)Integer.toString(types.length));
        for (int i = 0; i < types.length; ++i) {
            try {
                Method driverInstance = types[i].getMethod("instance", new Class[0]);
                BookDriver driver = (BookDriver)driverInstance.invoke(null, new Object[0]);
                this.registerDriver(driver);
                continue;
            }
            catch (NoSuchMethodException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (IllegalArgumentException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (IllegalAccessException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (InvocationTargetException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (BookException e) {
                Reporter.informUser(Books.class, e);
            }
        }
    }

    static {
        instance.autoRegister();
    }
}

