/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.crosswire.common.util.Histogram;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigEntry {
    private static final Pattern RTF_PATTERN = Pattern.compile("\\\\pard|\\\\pa[er]|\\\\qc|\\\\[bi]|\\\\u-?[0-9]{4,6}+");
    private static Histogram histogram = new Histogram();
    private ConfigEntryType type;
    private String internal;
    private String name;
    private List<String> values;
    private Object value;
    private static final Logger log = LoggerFactory.getLogger(ConfigEntry.class);

    public ConfigEntry(String bookName, String aName) {
        this.internal = bookName;
        this.name = aName;
        this.type = ConfigEntryType.fromString(aName);
    }

    public ConfigEntry(String bookName, ConfigEntryType aType, String aValue) {
        this.internal = bookName;
        this.name = aType.getName();
        this.type = aType;
        this.addValue(aValue);
    }

    public String getName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return this.name;
    }

    public ConfigEntryType getType() {
        return this.type;
    }

    public boolean isAllowed(String aValue) {
        if (this.type != null) {
            return this.type.isAllowed(aValue);
        }
        return true;
    }

    public boolean allowsRTF() {
        if (this.type != null) {
            return this.type.allowsRTF();
        }
        return true;
    }

    public boolean allowsContinuation() {
        if (this.type != null) {
            return this.type.allowsContinuation();
        }
        return true;
    }

    public boolean mayRepeat() {
        if (this.type != null) {
            return this.type.mayRepeat();
        }
        return true;
    }

    public boolean reportDetails() {
        if (this.type != null) {
            return this.type.reportDetails();
        }
        return true;
    }

    public boolean isSupported() {
        return this.type != null;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.values != null) {
            return this.values;
        }
        return this.type.getDefault();
    }

    public boolean match(Object search) {
        if (this.value != null) {
            return this.value.equals(search);
        }
        if (this.values != null) {
            return this.values.contains(search);
        }
        Object def = this.type.getDefault();
        return def != null && def.equals(search);
    }

    public void addValue(String val) {
        String aValue = val;
        String confEntryName = this.getName();
        if (this.type != null) {
            aValue = this.type.filter(aValue);
        }
        if (!this.allowsRTF() && RTF_PATTERN.matcher(aValue).find()) {
            log.info("Ignoring unexpected RTF for {} in {}: {}", new Object[]{confEntryName, this.internal, aValue});
        }
        if (this.mayRepeat()) {
            if (this.values == null) {
                histogram.increment(confEntryName);
                this.values = new ArrayList<String>();
            }
            if (this.reportDetails()) {
                histogram.increment(confEntryName + '.' + aValue);
            }
            if (!this.isAllowed(aValue)) {
                log.info("Ignoring unknown config value for {} in {}: {}", new Object[]{confEntryName, this.internal, aValue});
                return;
            }
            this.values.add(aValue);
        } else if (this.value != null) {
            log.info("Ignoring unexpected additional entry for {} in {}: {}", new Object[]{confEntryName, this.internal, aValue});
        } else {
            histogram.increment(confEntryName);
            if (this.type.hasChoices()) {
                histogram.increment(confEntryName + '.' + aValue);
            }
            if (!this.isAllowed(aValue)) {
                log.info("Ignoring unknown config value for {} in {}: {}", new Object[]{confEntryName, this.internal, aValue});
                return;
            }
            this.value = this.type.convert(aValue);
        }
    }

    public Element toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element rowEle = factory.createRow();
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        Element valueElement = factory.createCell();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        hiEle.addContent(this.getName());
        if (this.value != null) {
            String text = this.value.toString();
            text = XMLUtil.escape(text);
            if (this.allowsRTF()) {
                valueElement.addContent(OSISUtil.rtfToOsis(text));
            } else if (this.allowsContinuation()) {
                valueElement.addContent(this.processLines(factory, text));
            } else {
                valueElement.addContent(text);
            }
        }
        if (this.values != null) {
            Element listEle = factory.createLG();
            valueElement.addContent((Content)listEle);
            for (String str : this.values) {
                String text = XMLUtil.escape(str);
                Element itemEle = factory.createL();
                listEle.addContent((Content)itemEle);
                if (this.allowsRTF()) {
                    itemEle.addContent(OSISUtil.rtfToOsis(text));
                    continue;
                }
                itemEle.addContent(text);
            }
        }
        return rowEle;
    }

    public static void resetStatistics() {
        histogram.clear();
    }

    public static void dumpStatistics() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)obj;
        return that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public String toConf() {
        StringBuilder buf;
        block8: {
            buf = new StringBuilder();
            if (this.value != null) {
                buf.append(this.getName());
                buf.append('=');
                String text = this.getConfValue(this.value);
                if (this.allowsContinuation()) {
                    text = text.replaceAll("\n", "\\\\\n");
                }
                buf.append(text);
                buf.append('\n');
            } else if (this.type.equals((Object)ConfigEntryType.CIPHER_KEY)) {
                buf.append(this.getName());
                buf.append('=');
            }
            if (this.values == null) break block8;
            if (this.type.equals((Object)ConfigEntryType.HISTORY)) {
                for (String text : this.values) {
                    buf.append(this.getName());
                    buf.append('_');
                    buf.append(text.replaceFirst(" ", "="));
                    buf.append('\n');
                }
            } else {
                for (String text : this.values) {
                    buf.append(this.getName());
                    buf.append('=');
                    buf.append(this.getConfValue(text));
                    buf.append('\n');
                }
            }
        }
        return buf.toString();
    }

    private String getConfValue(Object aValue) {
        if (aValue != null) {
            if (this.type != null) {
                return this.type.unconvert(aValue);
            }
            return aValue.toString();
        }
        return null;
    }

    private List<Element> processLines(OSISUtil.OSISFactory factory, String aValue) {
        ArrayList<Element> list = new ArrayList<Element>();
        String[] lines = StringUtil.splitAll(aValue, '\n');
        for (int i = 0; i < lines.length; ++i) {
            Element lineElement = factory.createL();
            lineElement.addContent(lines[i]);
            list.add(lineElement);
        }
        return list;
    }
}

