/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterFactory;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntryTable;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.MissingDataFilesException;
import org.jdom2.Document;

public final class SwordBookMetaData
extends AbstractBookMetaData {
    private static final PropertyMap ENCODING_JAVA = new PropertyMap();
    private ConfigEntryTable cet;
    private BookCategory type;

    public SwordBookMetaData(File file, String internal, URI bookRootPath) throws IOException, MissingDataFilesException {
        this.cet = new ConfigEntryTable(internal);
        this.cet.load(file);
        this.setLibrary(bookRootPath);
        this.buildProperties();
    }

    public SwordBookMetaData(byte[] buffer, String internal) throws IOException {
        this.cet = new ConfigEntryTable(internal);
        this.cet.load(buffer);
        this.buildProperties();
    }

    @Override
    public boolean isQuestionable() {
        return this.cet.isQuestionable();
    }

    @Override
    public boolean isSupported() {
        return this.cet.isSupported() && this.cet.getBookType().isSupported(this);
    }

    @Override
    public boolean isEnciphered() {
        return this.cet.isEnciphered();
    }

    @Override
    public boolean isLocked() {
        return this.cet.isLocked();
    }

    @Override
    public boolean unlock(String unlockKey) {
        return this.cet.unlock(unlockKey);
    }

    @Override
    public String getUnlockKey() {
        return this.cet.getUnlockKey();
    }

    @Override
    public String getName() {
        return (String)this.getProperty(ConfigEntryType.DESCRIPTION);
    }

    public String getBookCharset() {
        return (String)ENCODING_JAVA.get(this.getProperty(ConfigEntryType.ENCODING));
    }

    @Override
    public KeyType getKeyType() {
        BookType bookType = this.getBookType();
        if (bookType == null) {
            return null;
        }
        return bookType.getKeyType();
    }

    public BookType getBookType() {
        return this.cet.getBookType();
    }

    public Filter getFilter() {
        String sourcetype = (String)this.getProperty(ConfigEntryType.SOURCE_TYPE);
        return FilterFactory.getFilter(sourcetype);
    }

    @Deprecated
    public String getConfPath() {
        return "mods.d/" + this.getInitials().toLowerCase(Locale.ENGLISH) + ".conf";
    }

    public File getConfigFile() {
        return this.cet.getConfigFile();
    }

    @Override
    public void setLibrary(URI library) throws MissingDataFilesException {
        URI location;
        File bookDir;
        if (!this.isSupported()) {
            return;
        }
        this.cet.add(ConfigEntryType.LIBRARY_URL, library.toString());
        super.setLibrary(library);
        String datapath = (String)this.getProperty(ConfigEntryType.DATA_PATH);
        int lastSlash = datapath.lastIndexOf(47);
        if (lastSlash == -1) {
            return;
        }
        boolean isDirectoryPath = false;
        if (lastSlash == datapath.length() - 1) {
            isDirectoryPath = true;
            datapath = datapath.substring(0, lastSlash);
        }
        if (!(bookDir = new File((location = NetUtil.lengthenURI(library, datapath)).getPath())).isDirectory()) {
            if (isDirectoryPath) {
                throw new MissingDataFilesException(JSMsg.gettext("The book is missing its data files", this.cet.getValue(ConfigEntryType.INITIALS)));
            }
            if (!new File(location.getPath() + ".dat").exists()) {
                throw new MissingDataFilesException(JSMsg.gettext("The book {0} is missing its data files", this.cet.getValue(ConfigEntryType.INITIALS)));
            }
            lastSlash = datapath.lastIndexOf(47);
            datapath = datapath.substring(0, lastSlash);
            location = NetUtil.lengthenURI(library, datapath);
        }
        this.cet.add(ConfigEntryType.LOCATION_URL, location.toString());
        super.setLocation(location);
    }

    @Override
    public BookCategory getBookCategory() {
        if (this.type == null) {
            this.type = (BookCategory)((Object)this.getProperty(ConfigEntryType.CATEGORY));
            if (this.type == BookCategory.OTHER) {
                this.type = this.getBookType().getBookCategory();
            }
        }
        return this.type;
    }

    @Override
    public Document toOSIS() {
        return new Document(this.cet.toOSIS());
    }

    @Override
    public String getInitials() {
        return (String)this.getProperty(ConfigEntryType.INITIALS);
    }

    public Object getProperty(ConfigEntryType entry) {
        return this.cet.getValue(entry);
    }

    @Override
    public boolean isLeftToRight() {
        String dir = (String)this.getProperty(ConfigEntryType.DIRECTION);
        if ("bidi".equalsIgnoreCase(dir)) {
            Language lang = (Language)this.getProperty(ConfigEntryType.LANG);
            return lang.isLeftToRight();
        }
        return "LtoR".equalsIgnoreCase(dir);
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        String name = feature.toString();
        if (this.cet.match(ConfigEntryType.FEATURE, name)) {
            return true;
        }
        StringBuilder buffer = new StringBuilder((String)this.getProperty(ConfigEntryType.SOURCE_TYPE));
        buffer.append(name);
        if (this.cet.match(ConfigEntryType.GLOBAL_OPTION_FILTER, buffer.toString())) {
            return true;
        }
        String alias = feature.getAlias();
        buffer.setLength(0);
        buffer.append((String)this.getProperty(ConfigEntryType.SOURCE_TYPE));
        buffer.append(alias);
        return this.cet.match(ConfigEntryType.GLOBAL_OPTION_FILTER, name) || this.cet.match(ConfigEntryType.GLOBAL_OPTION_FILTER, alias);
    }

    private void buildProperties() {
        for (ConfigEntryType key : this.cet.getKeys()) {
            Object value = this.cet.getValue(key);
            if (value == null) continue;
            if (value instanceof List) {
                List list = (List)value;
                StringBuilder combined = new StringBuilder();
                boolean appendSeparator = false;
                for (String element : list) {
                    if (appendSeparator) {
                        combined.append('\n');
                    }
                    combined.append(element);
                    appendSeparator = true;
                }
                value = combined.toString();
            }
            this.putProperty(key.toString(), value);
        }
    }

    static {
        ENCODING_JAVA.put("Latin-1", "WINDOWS-1252");
        ENCODING_JAVA.put("UTF-8", "UTF-8");
    }
}

