/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.crosswire.common.compress.CompressorType;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.DataEntry;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.book.sword.state.RawLDBackendState;
import org.crosswire.jsword.book.sword.state.ZLDBackendState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZLDBackend
extends RawLDBackend<ZLDBackendState> {
    private static final int ZDX_ENTRY_SIZE = 8;
    private static final int BLOCK_ENTRY_COUNT = 4;
    private static final int BLOCK_ENTRY_SIZE = 8;
    private static final Logger log = LoggerFactory.getLogger(ZLDBackend.class);
    private static final long serialVersionUID = 3536098410391064446L;

    public ZLDBackend(SwordBookMetaData sbmd) {
        super(sbmd, 4);
    }

    @Override
    public ZLDBackendState initState() throws BookException {
        return OpenFileStateManager.getZLDBackendState(this.getBookMetaData());
    }

    @Override
    protected DataEntry getEntry(RawLDBackendState fileState, DataEntry entry) {
        ZLDBackendState state = null;
        if (!(fileState instanceof ZLDBackendState)) {
            log.error("Backend State was not of type ZLDBackendState. Ignoring this entry and exiting.");
            return new DataEntry(entry.getName(), new byte[0], entry.getCharset());
        }
        state = (ZLDBackendState)fileState;
        DataIndex blockIndex = entry.getBlockIndex();
        long blockNum = blockIndex.getOffset();
        int blockEntry = blockIndex.getSize();
        byte[] uncompressed = null;
        if (blockNum == state.getLastBlockNum()) {
            uncompressed = state.getLastUncompressed();
        } else {
            try {
                byte[] temp = SwordUtil.readRAF(state.getZdxRaf(), blockNum * 8L, 8);
                if (temp == null || temp.length == 0) {
                    return new DataEntry(entry.getName(), new byte[0], entry.getCharset());
                }
                int blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
                int blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
                temp = SwordUtil.readRAF(state.getZdtRaf(), blockStart, blockSize);
                this.decipher(temp);
                String compressType = (String)this.getBookMetaData().getProperty(ConfigEntryType.COMPRESS_TYPE);
                uncompressed = CompressorType.fromString(compressType).getCompressor(temp).uncompress().toByteArray();
                state.setLastBlockNum(blockNum);
                state.setLastUncompressed(uncompressed);
            }
            catch (IOException e) {
                return new DataEntry(entry.getName(), new byte[0], entry.getCharset());
            }
        }
        int entryCount = SwordUtil.decodeLittleEndian32(uncompressed, 0);
        if (blockEntry >= entryCount) {
            return new DataEntry(entry.getName(), new byte[0], entry.getCharset());
        }
        int entryOffset = 4 + 8 * blockEntry;
        int entryStart = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset);
        int entrySize = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset + 4);
        int nullTerminator = SwordUtil.findByte(uncompressed, entryStart, (byte)0);
        if (nullTerminator - entryStart + 1 == entrySize) {
            --entrySize;
        }
        byte[] entryBytes = new byte[entrySize];
        System.arraycopy(uncompressed, entryStart, entryBytes, 0, entrySize);
        DataEntry finalEntry = new DataEntry(entry.getName(), entryBytes, this.getBookMetaData().getBookCharset());
        return finalEntry;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
    }
}

