/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.passage.AccuracyType;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public final class VerseRangeFactory {
    private VerseRangeFactory() {
    }

    @Deprecated
    public static VerseRange fromString(String orginal) throws NoSuchVerseException {
        return VerseRangeFactory.fromString(Versifications.instance().getDefaultVersification(), orginal, null);
    }

    public static VerseRange fromString(Versification v11n, String orginal) throws NoSuchVerseException {
        return VerseRangeFactory.fromString(v11n, orginal, null);
    }

    @Deprecated
    public static VerseRange fromString(String original, VerseRange basis) throws NoSuchVerseException {
        return VerseRangeFactory.fromString(Versifications.instance().getDefaultVersification(), original, basis);
    }

    public static VerseRange fromString(Versification v11n, String original, VerseRange basis) throws NoSuchVerseException {
        String[] parts = StringUtil.split(original, "-");
        switch (parts.length) {
            case 1: {
                return VerseRangeFactory.fromText(v11n, original, parts[0], parts[0], basis);
            }
            case 2: {
                return VerseRangeFactory.fromText(v11n, original, parts[0], parts[1], basis);
            }
        }
        throw new NoSuchVerseException(JSMsg.gettext("A verse range cannot have more than 2 parts. (Parts are separated by {0}) Given {1}", "-", original));
    }

    private static VerseRange fromText(Versification v11n, String original, String startVerseDesc, String endVerseDesc, VerseRange basis) throws NoSuchVerseException {
        String[] startParts = AccuracyType.tokenize(startVerseDesc);
        AccuracyType accuracyStart = AccuracyType.fromText(v11n, original, startParts, basis);
        Verse start = accuracyStart.createStartVerse(v11n, startVerseDesc, basis, startParts);
        v11n.validate(start.getBook(), start.getChapter(), start.getVerse());
        String[] endParts = startVerseDesc.equals(endVerseDesc) ? startParts : AccuracyType.tokenize(endVerseDesc);
        AccuracyType accuracyEnd = AccuracyType.fromText(v11n, original, endParts, accuracyStart, basis);
        Verse end = accuracyEnd.createEndVerse(v11n, endVerseDesc, start, endParts);
        v11n.validate(end.getBook(), end.getChapter(), end.getVerse());
        return new VerseRange(v11n, original, start, end);
    }
}

