/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PatternFormatter
extends Formatter {
    private Date dat = new Date();
    private static final String DEFAULT_FORMAT = "{1}({2}): {3}{8} {4}";
    private String lineSeparator = System.getProperty("line.separator", "\r\n");

    public synchronized String format(LogRecord record) {
        Logger logger;
        this.dat.setTime(record.getMillis());
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        String format = LogManager.getLogManager().getProperty(PatternFormatter.class.getName() + ".format");
        String loggerName = record.getLoggerName();
        for (Logger aLogger = logger = LogManager.getLogManager().getLogger(loggerName); aLogger != null; aLogger = aLogger.getParent()) {
            String property = null;
            String aLoggerName = aLogger.getName();
            if (aLoggerName != null) {
                property = LogManager.getLogManager().getProperty(aLoggerName + ".format");
            }
            if (property == null) continue;
            format = property;
            break;
        }
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        return MessageFormat.format(format, this.dat, record.getLoggerName(), record.getLevel().getLocalizedName(), this.formatMessage(record), throwable, record.getSourceClassName(), record.getSourceMethodName(), record.getSequenceNumber(), this.lineSeparator);
    }
}

