/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.util.List;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.examples.Speed;

public final class Bench {
    private Bench() {
    }

    public static void main(String[] args) {
        Book version = null;
        if (args.length == 0) {
            Bench.usage();
            Bench.versions();
        }
        List<Book> dicts = Books.installed().getBooks(BookFilters.getOnlyBibles());
        version = dicts.get(0);
        Speed speed = new Speed(version);
        speed.run();
        double time = (double)speed.getBenchmark() / 1000.0;
        System.out.println("CBench mark for '" + version + "': " + time + "s");
    }

    private static void usage() {
        System.out.println("Usage: CBench [<version>] [disk]");
        System.out.println("  where <version> is the name of a version to benchmark.");
        System.out.println("  and 'disk' specifies if the Raw version should not cache data.");
        System.out.println("  Remember to quote the version name if it includes spaces.");
    }

    private static void versions() {
        System.out.println("  Available versions:");
        List<Book> lbmds = Books.installed().getBooks();
        for (Book book : lbmds) {
            System.out.println("    " + book.getName());
        }
    }
}

