/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.study.StrongsMapSet;
import org.crosswire.jsword.book.study.StrongsNumber;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrongsAnalysis {
    private static Pattern strongsNumberPattern = Pattern.compile("strong:([GH][0-9]+)");

    public StrongsAnalysis() {
        Book bible = Books.installed().getBook("KJV");
        if (!bible.hasFeature(FeatureType.STRONGS_NUMBERS)) {
            bible = null;
            List<Book> bibles = Books.installed().getBooks(new BookFilters.BookFeatureFilter(FeatureType.STRONGS_NUMBERS));
            if (!bibles.isEmpty()) {
                bible = bibles.get(0);
            }
        }
        if (bible == null) {
            return;
        }
        ArrayList<Key> errors = new ArrayList<Key>();
        StrongsMapSet sms = new StrongsMapSet();
        this.analyze(sms, bible, errors, bible.getGlobalKeyList());
    }

    public void analyze(StrongsMapSet sms, Book book, List<Key> errors, Key wholeBible) {
        BookData data = null;
        Element osis = null;
        StringBuilder buffer = new StringBuilder();
        for (Key subkey : wholeBible) {
            if (subkey.canHaveChildren()) {
                this.analyze(sms, book, errors, subkey);
                continue;
            }
            data = new BookData(book, subkey);
            osis = null;
            try {
                osis = data.getOsisFragment();
            }
            catch (BookException e) {
                errors.add(subkey);
                continue;
            }
            for (Content content : OSISUtil.getDeepContent(osis, "w")) {
                int len = buffer.length();
                if (len > 0) {
                    buffer.delete(0, len);
                }
                Element wElement = (Element)content;
                String snAttr = wElement.getAttributeValue("lemma");
                String text = OSISUtil.getPlainText(wElement);
                Matcher matcher = strongsNumberPattern.matcher(snAttr);
                while (matcher.find()) {
                    StrongsNumber strongsNumber = new StrongsNumber(matcher.group(1));
                    if (!strongsNumber.isValid()) continue;
                    if (buffer.length() > 0) {
                        buffer.append(' ');
                    }
                    buffer.append(strongsNumber.getStrongsNumber());
                }
                sms.add(buffer.toString(), text);
            }
        }
    }

    public static void main(String[] args) {
        new StrongsAnalysis();
    }
}

