/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookType;
import org.crosswire.jsword.book.FeatureType;

public class BookFilters {
    private static BookFilter allBookFilter = new AllBookFilter();
    private static BookFilter biblesBookFilter = new BiblesBookFilter();
    private static BookFilter dictionariesBookFilter = new DictionariesBookFilter();
    private static BookFilter commentariesBookFilter = new CommentariesBookFilter();
    private static BookFilter greekDefinitionsBookFilter = new GreekDefinitionsBookFilter();
    private static BookFilter greekParseBookFilter = new GreekParseBookFilter();
    private static BookFilter hebrewDefinitionsBookFilter = new HebrewDefinitionsBookFilter();
    private static BookFilter hebrewParseBookFilter = new HebrewParseBookFilter();

    private BookFilters() {
    }

    public static BookFilter getAll() {
        return allBookFilter;
    }

    public static BookFilter getBibles() {
        return biblesBookFilter;
    }

    public static BookFilter getDictionaries() {
        return dictionariesBookFilter;
    }

    public static BookFilter getCommentaries() {
        return commentariesBookFilter;
    }

    public static BookFilter getGreekDefinitions() {
        return greekDefinitionsBookFilter;
    }

    public static BookFilter getGreekParse() {
        return greekParseBookFilter;
    }

    public static BookFilter getHebrewDefinitions() {
        return hebrewDefinitionsBookFilter;
    }

    public static BookFilter getHebrewParse() {
        return hebrewParseBookFilter;
    }

    public static BookFilter both(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            public boolean test(Book book) {
                return b1.test(book) && b2.test(book);
            }
        };
    }

    public static BookFilter either(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            public boolean test(Book book) {
                return b1.test(book) || b2.test(book);
            }
        };
    }

    public static BookFilter getBooksByDriver(final BookDriver driver) {
        return new BookFilter(){

            public boolean test(Book book) {
                return book.getDriver() == driver;
            }
        };
    }

    private static class HebrewParseBookFilter
    implements BookFilter {
        private HebrewParseBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.HEBREW_PARSE);
        }
    }

    private static class HebrewDefinitionsBookFilter
    implements BookFilter {
        private HebrewDefinitionsBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.HEBREW_DEFINITIONS);
        }
    }

    private static class GreekParseBookFilter
    implements BookFilter {
        private GreekParseBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.GREEK_PARSE);
        }
    }

    private static class GreekDefinitionsBookFilter
    implements BookFilter {
        private GreekDefinitionsBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.GREEK_DEFINITIONS);
        }
    }

    private static class CommentariesBookFilter
    implements BookFilter {
        private CommentariesBookFilter() {
        }

        public boolean test(Book book) {
            return book.getType().equals(BookType.COMMENTARY);
        }
    }

    private static class DictionariesBookFilter
    implements BookFilter {
        private DictionariesBookFilter() {
        }

        public boolean test(Book book) {
            return book.getType().equals(BookType.DICTIONARY);
        }
    }

    private static class BiblesBookFilter
    implements BookFilter {
        private BiblesBookFilter() {
        }

        public boolean test(Book book) {
            return book.getType().equals(BookType.BIBLE);
        }
    }

    private static class AllBookFilter
    implements BookFilter {
        private AllBookFilter() {
        }

        public boolean test(Book book) {
            return true;
        }
    }
}

