/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;

public class BibleComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private static final Logger log;
    public static final int LEVEL_BOOK = 0;
    public static final int LEVEL_CHAPTER = 1;
    public static final int LEVEL_VERSE = 2;
    private BibleComboBoxModelSet set;
    private Object selected;
    protected int level;
    private static final long serialVersionUID = 3616449020667442997L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BibleComboBoxModel(BibleComboBoxModelSet set, int level) {
        this.set = set;
        this.level = level;
        switch (level) {
            case 0: {
                try {
                    this.selected = BibleInfo.getLongBookName((int)set.getVerse().getBook());
                    break;
                }
                catch (NoSuchVerseException ex) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)ex);
                    }
                    break;
                }
            }
            case 1: {
                this.selected = new Integer(set.getVerse().getChapter());
                break;
            }
            case 2: {
                this.selected = new Integer(set.getVerse().getVerse());
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(level);
                }
                break;
            }
        }
    }

    public void setSelectedItem(Object selected) {
        log.debug("setSelectedItem(" + selected + ") level=" + this.level);
        switch (this.level) {
            case 0: {
                String bsel = (String)selected;
                int book = BibleInfo.getBookNumber((String)bsel);
                if (!$assertionsDisabled && book <= 0) {
                    throw new AssertionError();
                }
                this.setBook(book);
                break;
            }
            case 1: {
                Integer csel = (Integer)selected;
                this.setChapter(csel);
                break;
            }
            case 2: {
                Integer vsel = (Integer)selected;
                this.setVerse(vsel);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.level);
                }
                break;
            }
        }
        this.selected = selected;
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public int getSize() {
        try {
            switch (this.level) {
                case 0: {
                    return BibleInfo.booksInBible();
                }
                case 1: {
                    return BibleInfo.chaptersInBook((int)this.set.getVerse().getBook());
                }
                case 2: {
                    return BibleInfo.versesInChapter((int)this.set.getVerse().getBook(), (int)this.set.getVerse().getChapter());
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError(this.level);
            }
            return 0;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return 0;
        }
    }

    public Object getElementAt(int index) {
        try {
            switch (this.level) {
                case 0: {
                    return BibleInfo.getLongBookName((int)(index + 1));
                }
                case 1: 
                case 2: {
                    return new Integer(index + 1);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError(this.level);
            }
            return null;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    public void setBook(int book) {
        block4: {
            try {
                Verse old = this.set.getVerse();
                int chapter = old.getChapter();
                int verse = old.getVerse();
                if (BibleInfo.chaptersInBook((int)book) < chapter) {
                    chapter = 1;
                }
                if (BibleInfo.versesInChapter((int)book, (int)chapter) < verse) {
                    verse = 1;
                }
                Verse update = new Verse(book, chapter, verse, true);
                this.set.setViewedVerse(update);
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public void setChapter(int chapter) {
        block3: {
            try {
                Verse old = this.set.getVerse();
                int book = old.getBook();
                int verse = old.getVerse();
                if (BibleInfo.versesInChapter((int)book, (int)chapter) < verse) {
                    verse = 1;
                }
                Verse update = new Verse(book, chapter, verse, true);
                this.set.setViewedVerse(update);
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public void setVerse(int verse) {
        Verse old = this.set.getVerse();
        Verse update = new Verse(old.getBook(), old.getChapter(), verse, true);
        this.set.setViewedVerse(update);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    static {
        $assertionsDisabled = !BibleComboBoxModel.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)BibleComboBoxModel.class);
    }
}

