/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.Books;

public class DriversListModel
extends AbstractListModel {
    protected BookDriver[] drivers;
    protected static final Icon SMALL_ICON = GuiUtil.getIcon((String)"/org/crosswire/resources/task_small.gif");
    protected static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = 3689068456540910136L;

    public DriversListModel(boolean includeRo) {
        this.drivers = includeRo ? Books.installed().getDrivers() : Books.installed().getWritableDrivers();
    }

    public DriversListModel() {
        this(true);
    }

    public int getSize() {
        return this.drivers.length;
    }

    public Object getElementAt(int index) {
        if (index >= this.drivers.length) {
            return null;
        }
        return this.drivers[index].getClass().getName();
    }

    public String getDriverName(Object test) {
        String item = test.toString();
        int end = item.indexOf(" (");
        return item.substring(0, end);
    }

    public BookDriver getDriver(Object test) {
        return this.drivers[this.getIndexOf(test)];
    }

    public int getIndexOf(Object test) {
        for (int i = 0; i < this.drivers.length; ++i) {
            if (!test.equals(this.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static ListCellRenderer getListCellRenderer() {
        return new BibleListCellRenderer();
    }

    public static class BibleListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3256722892245971512L;

        public BibleListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(NO_FOCUS_BORDER);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
            if (selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value == null ? "" : value.toString());
            this.setIcon(SMALL_ICON);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            return this;
        }
    }
}

