/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.util.ConfigurableSwingConverter;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.FormatType;
import org.crosswire.common.xml.HTMLSerializingContentHandler;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.ContentHandler;

public class ViewSourcePane
extends JPanel {
    private JTabbedPane tabMain;
    private JTextComponent[] textAreas;
    private JPanel pnlButtons;
    private JDialog frame;
    private ActionFactory actions;
    private static Converter converter = ConverterFactory.getConverter();
    private static final long serialVersionUID = 3257281435579985975L;

    public ViewSourcePane(Book book, Key key) {
        try {
            String orig = book.getRawData(key);
            BookData bdata = book.getData(key);
            BookMetaData bmd = book.getBookMetaData();
            boolean direction = bmd.isLeftToRight();
            SAXEventProvider osissep = bdata.getSAXEventProvider();
            HTMLSerializingContentHandler osis = new HTMLSerializingContentHandler(FormatType.CLASSIC_INDENT);
            osissep.provideSAXEvents((ContentHandler)osis);
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)converter.convert(osissep);
            htmlsep.setParameter(XSLTProperty.STRONGS_NUMBERS.getName(), (Object)Boolean.toString(XSLTProperty.STRONGS_NUMBERS.getState()));
            htmlsep.setParameter(XSLTProperty.START_VERSE_ON_NEWLINE.getName(), (Object)Boolean.toString(XSLTProperty.START_VERSE_ON_NEWLINE.getState()));
            htmlsep.setParameter(XSLTProperty.VERSE_NUMBERS.getName(), (Object)Boolean.toString(XSLTProperty.VERSE_NUMBERS.getState()));
            htmlsep.setParameter(XSLTProperty.TINY_VERSE_NUMBERS.getName(), (Object)Boolean.toString(XSLTProperty.TINY_VERSE_NUMBERS.getState()));
            htmlsep.setParameter(XSLTProperty.NOTES.getName(), (Object)Boolean.toString(XSLTProperty.NOTES.getState()));
            htmlsep.setParameter(XSLTProperty.XREF.getName(), (Object)Boolean.toString(XSLTProperty.XREF.getState()));
            htmlsep.setParameter("direction", (Object)(direction ? "ltr" : "rtl"));
            HTMLSerializingContentHandler html = new HTMLSerializingContentHandler(FormatType.CLASSIC_INDENT);
            htmlsep.provideSAXEvents((ContentHandler)html);
            this.init(orig, osis.toString(), html.toString());
        }
        catch (Exception ex) {
            Reporter.informUser(null, (Throwable)ex);
        }
    }

    public ViewSourcePane(String orig, String osis, String html) {
        this.init(orig, osis, html);
    }

    private void init(String orig, String osis, String html) {
        this.actions = new ActionFactory(ViewSourcePane.class, (Object)this);
        Font userRequestedFont = ConfigurableSwingConverter.toFont();
        JTextArea txtOrig = new JTextArea(orig, 24, 80);
        txtOrig.setFont(userRequestedFont);
        txtOrig.setLineWrap(true);
        txtOrig.setWrapStyleWord(true);
        txtOrig.setTabSize(2);
        txtOrig.setEditable(false);
        JPanel pnlOrig = new JPanel(new BorderLayout());
        pnlOrig.add((Component)new JScrollPane(txtOrig), "Center");
        pnlOrig.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AntiAliasedTextPane txtOsis = new AntiAliasedTextPane();
        txtOsis.setFont(userRequestedFont);
        txtOsis.setEditable(false);
        txtOsis.setEditorKit(new HTMLEditorKit());
        txtOsis.setText(osis);
        txtOsis.setCaretPosition(0);
        JPanel pnlOsis = new JPanel(new BorderLayout());
        pnlOsis.add((Component)new JScrollPane((Component)txtOsis), "Center");
        pnlOsis.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AntiAliasedTextPane txtHtml = new AntiAliasedTextPane();
        txtHtml.setFont(userRequestedFont);
        txtHtml.setEditable(false);
        txtHtml.setEditorKit(new HTMLEditorKit());
        txtHtml.setText(html);
        txtHtml.setCaretPosition(0);
        JPanel pnlHtml = new JPanel(new BorderLayout());
        pnlHtml.add((Component)new JScrollPane((Component)txtHtml), "Center");
        pnlHtml.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textAreas = new JTextComponent[]{txtOrig, txtOsis, txtHtml};
        this.pnlButtons = new JPanel(new FlowLayout(2));
        this.pnlButtons.add((Component)new JButton(this.actions.getAction("SourceClip")), null);
        this.tabMain = new JTabbedPane();
        this.tabMain.add((Component)pnlOrig, Msg.ORIG.toString());
        this.tabMain.add((Component)pnlOsis, Msg.OSIS.toString());
        this.tabMain.add((Component)pnlHtml, Msg.HTML.toString());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabMain, "Center");
        this.add((Component)this.pnlButtons, "South");
    }

    public void showInFrame(Frame parent) {
        this.frame = new JDialog(parent, Msg.TEXT_VIEWER.toString());
        this.pnlButtons.add((Component)new JButton(this.actions.getAction("SourceOK")), null);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.pack();
        GuiUtil.centerWindow((Window)this.frame);
        this.frame.setVisible(true);
    }

    public void doSourceClip() {
        int i = this.tabMain.getSelectedIndex();
        JTextComponent tc = this.textAreas[i];
        StringSelection ss = new StringSelection(tc.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void doSourceOK() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }
}

